/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.clientBundle.css.language.GwtCssLanguage;
import com.intellij.gwt.clientBundle.css.language.psi.GwtCssDef;
import com.intellij.gwt.clientBundle.jam.CssResourceClassJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceMethodJamElement;
import com.intellij.gwt.codeInsight.GwtMethodGenerationUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssResourceClassErrorsInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            CssResourceClassErrorsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            CssResourceClassErrorsInspection.$$$reportNull$$$0(1);
        }
        if (!CssResourceClassErrorsInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        CssResourceClassJamElement element = CssResourceClassJamElement.getJamElement(aClass);
        if (element == null) {
            return null;
        }
        Set<StylesheetFile> stylesheetFiles = element.findStylesheetFiles(false, false);
        StylesheetFile mainStylesheetFile = (StylesheetFile)ContainerUtil.getFirstItem(stylesheetFiles, null);
        if (mainStylesheetFile == null) {
            return null;
        }
        MultiMap unusedCssClasses = new MultiMap();
        for (StylesheetFile stylesheetFile : stylesheetFiles) {
            GwtCssDeclarationsManager.collectDeclarations(stylesheetFile, CssClass.class, unusedCssClasses);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (CssResourceMethodJamElement methodElement : element.getCssMethods()) {
            ProblemHighlightType type;
            PsiLiteral place;
            String className = methodElement.getCssClassName();
            unusedCssClasses.remove((Object)className);
            if (!methodElement.findCssElements().isEmpty()) continue;
            PsiMethod method = methodElement.getPsiMethod();
            if (!aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)method.getContainingClass())) continue;
            CreateCssClassLocalQuickFix createClassFix = new CreateCssClassLocalQuickFix(mainStylesheetFile, className);
            CreateCssDefLocalQuickFix createDefFix = new CreateCssDefLocalQuickFix(className, mainStylesheetFile);
            String message = "'" + className + "' css class of '@def' element not found";
            PsiLiteral literal = methodElement.getClassNameAttributeElement().getPsiLiteral();
            if (literal != null) {
                place = literal;
                type = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            } else {
                place = CssResourceClassErrorsInspection.getElementToHighlight(method);
                type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }
            result.add(manager.createProblemDescriptor((PsiElement)place, message, isOnTheFly, new LocalQuickFix[]{createClassFix, createDefFix}, type));
        }
        if (!unusedCssClasses.isEmpty()) {
            String quickFixName;
            String message;
            Set set = unusedCssClasses.keySet();
            if (set.size() == 1) {
                String className = (String)set.iterator().next();
                message = "Css class '" + className + "' does not have corresponding method";
                quickFixName = "Create method for '" + className + "'";
            } else {
                message = set.size() + " css classes do not have corresponding methods";
                quickFixName = "Create missing methods";
            }
            CreateMissingMethodsQuickFix fix = new CreateMissingMethodsQuickFix(aClass, set, quickFixName);
            result.add(manager.createProblemDescriptor(CssResourceClassErrorsInspection.getElementToHighlight(aClass), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("CssResource Errors" == null) {
            CssResourceClassErrorsInspection.$$$reportNull$$$0(2);
        }
        return "CssResource Errors";
    }

    @NotNull
    public String getShortName() {
        if ("GwtCssResourceErrors" == null) {
            CssResourceClassErrorsInspection.$$$reportNull$$$0(3);
        }
        return "GwtCssResourceErrors";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateCssDefLocalQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.clientBundle.CssResourceClassErrorsInspection.CreateCssDefLocalQuickFix");
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.def.declaration", new Object[0]);
        private final String myDefName;

        CreateCssDefLocalQuickFix(String defName, StylesheetFile cssFile) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.create.def.declaration.for.0", defName), (PsiElement)cssFile);
            this.myDefName = defName;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateCssDefLocalQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CreateCssDefLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CreateCssDefLocalQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                CreateCssDefLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof StylesheetFile)) {
                return;
            }
            StylesheetFile cssFile = (StylesheetFile)startElement;
            VirtualFile virtualFile = cssFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
                return;
            }
            try {
                CssStylesheet stylesheet = cssFile.getStylesheet();
                GwtCssDef cssDef = (GwtCssDef)stylesheet.getRulesetList().add((PsiElement)CreateCssDefLocalQuickFix.createCssDef(project, this.myDefName));
                GwtCssDef processed = (GwtCssDef)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)cssDef);
                Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, processed.getTextRange().getEndOffset() - 1);
                descriptor.navigate(true);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static GwtCssDef createCssDef(Project project, String defName) {
            PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy_.css", (Language)GwtCssLanguage.GWT_CSS_LANGUAGE, (CharSequence)("@def " + defName + ";"));
            CssRulesetList rulesetList = ((StylesheetFile)file).getStylesheet().getRulesetList();
            return (GwtCssDef)PsiTreeUtil.findChildOfType((PsiElement)rulesetList, GwtCssDef.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateCssDefLocalQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CreateMissingMethodsQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final Set<String> myClassNames;

        CreateMissingMethodsQuickFix(PsiClass aClass, Set<String> classNames, String name) {
            super(FAMILY_NAME, name, (PsiElement)aClass);
            this.myClassNames = classNames;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateMissingMethodsQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CreateMissingMethodsQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CreateMissingMethodsQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                CreateMissingMethodsQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass psiClass = (PsiClass)startElement;
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)psiClass);
            for (String className : this.myClassNames) {
                String methodName = GwtMethodGenerationUtil.convertStringToMethodName(className, PsiNameHelper.getInstance((Project)project), languageLevel, "class");
                PsiMethod method = GwtMethodGenerationUtil.addStringMethod(psiClass, methodName);
                if (!methodName.equals(className)) {
                    String annotationText = "@com.google.gwt.resources.client.CssResource.ClassName(\"" + className + "\")";
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    method.getModifierList().add((PsiElement)elementFactory.createAnnotationFromText(annotationText, (PsiElement)psiClass));
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/clientBundle/CssResourceClassErrorsInspection$CreateMissingMethodsQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

