/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateGwtUiBinderDialog
extends DialogWrapper {
    private static final String[] DEFAULT_ROOT_ELEMENT_TYPES = new String[]{"com.google.gwt.user.client.ui.HTMLPanel", "com.google.gwt.dom.client.DivElement"};
    private JPanel myMainPanel;
    private JTextField myNameTextField;
    private ReferenceEditorComboWithBrowseButton myRootElementTypeEditor;
    private final InputValidator myValidator;
    private final Project myProject;
    private final GwtFacet myFacet;
    private final Ref<? super String> myRootElementType;
    @NonNls
    private static final String RECENT_ROOT_ELEMENT_KEY = "GwtCreateUiBinderDialog.RecentRootElementType";

    public CreateGwtUiBinderDialog(Project project, GwtFacet facet, String dialogTitle, InputValidator validator, Ref<? super String> rootElementType) {
        super(project);
        this.myProject = project;
        this.myFacet = facet;
        this.myRootElementType = rootElementType;
        this.$$$setupUI$$$();
        this.setTitle(dialogTitle);
        this.myValidator = validator;
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CreateGwtUiBinderDialog.this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)CreateGwtUiBinderDialog.this.myNameTextField.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/gwt/actions/CreateGwtUiBinderDialog$1", "textChanged"));
            }
        });
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    protected void doOKAction() {
        String name = this.myNameTextField.getText();
        String rootElementType = this.myRootElementTypeEditor.getText().trim();
        if (StringUtil.isEmpty((String)rootElementType)) {
            Messages.showErrorDialog((Project)this.myProject, (String)"Root element type is not specified", (String)CommonBundle.getErrorTitle());
            return;
        }
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_ROOT_ELEMENT_KEY, rootElementType);
        this.myRootElementType.set((Object)rootElementType);
        if (this.myValidator.checkInput(name) && this.myValidator.canClose(name)) {
            super.doOKAction();
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)CreateGwtUiBinderDialog.this.myProject);
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)CreateGwtUiBinderDialog.this.myFacet.getModule());
                PsiClass elementClass = JavaPsiFacade.getInstance((Project)CreateGwtUiBinderDialog.this.myProject).findClass("com.google.gwt.dom.client.Element", scope);
                PsiClass widgetBaseClass = JavaPsiFacade.getInstance((Project)CreateGwtUiBinderDialog.this.myProject).findClass("com.google.gwt.user.client.ui.IsWidget", scope);
                TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser("Select Type of Root Element", scope, (ClassFilter)new RootElementClassFilter(elementClass, widgetBaseClass), null);
                chooser.showDialog();
                PsiClass psiClass = chooser.getSelected();
                if (psiClass != null) {
                    CreateGwtUiBinderDialog.this.myRootElementTypeEditor.setText(psiClass.getQualifiedName());
                }
            }
        };
        this.myRootElementTypeEditor = new ReferenceEditorComboWithBrowseButton(listener, "", this.myProject, true, RECENT_ROOT_ELEMENT_KEY);
        for (String elementType : DEFAULT_ROOT_ELEMENT_TYPES) {
            this.myRootElementTypeEditor.prependItem(elementType);
        }
        List classes = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(RECENT_ROOT_ELEMENT_KEY);
        if (classes != null) {
            for (int i = classes.size() - 1; i >= 0; --i) {
                this.myRootElementTypeEditor.prependItem((String)classes.get(i));
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.enter.name.for.new.gwt.uibinder.class.and.ui.xml.file"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.select.root.element.type"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myRootElementTypeEditor;
        jPanel.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, null, null, null, 1));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)referenceEditorComboWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class RootElementClassFilter
    implements ClassFilter {
        private final PsiClass[] myBaseClasses;

        RootElementClassFilter(PsiClass ... baseClasses) {
            this.myBaseClasses = baseClasses;
        }

        public boolean isAccepted(PsiClass aClass) {
            for (PsiClass baseClass : this.myBaseClasses) {
                if (baseClass != null && !aClass.isInheritor(baseClass, true)) continue;
                return true;
            }
            return false;
        }
    }
}

