/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.CreateGwtUiBinderDialog;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.uiBinder.GwtHtmlElementClassesFinder;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateGwtUiBinderAction
extends GwtCreateActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.actions.CreateGwtUiBinderAction");
    private final Ref<String> myRootElementType = new Ref(null);

    public CreateGwtUiBinderAction() {
        super(GwtBundle.message("create.gwt.uibinder.action.name", new Object[0]), GwtBundle.message("create.gwt.uibinder.action.description", new Object[0]));
    }

    @Override
    protected void showDialog(@NotNull GwtFacet facet, @NotNull PsiDirectory directory, @NotNull CreateElementActionBase.MyInputValidator validator) {
        if (facet == null) {
            CreateGwtUiBinderAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateGwtUiBinderAction.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            CreateGwtUiBinderAction.$$$reportNull$$$0(2);
        }
        Project project = facet.getModule().getProject();
        if (!facet.getSdkVersion().isUiBinderSupported()) {
            Messages.showErrorDialog((Project)project, (String)GwtBundle.message("error.message.uibinder.is.supported.in.gwt.2.0.or.later", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        CreateGwtUiBinderDialog dialog = new CreateGwtUiBinderDialog(project, facet, this.getDialogTitle(), (InputValidator)validator, this.myRootElementType);
        dialog.show();
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String name, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        boolean isWidget;
        Project project = directory.getProject();
        GwtFacet facet = GwtFacet.findFacetBySourceFile(project, directory.getVirtualFile());
        LOG.assertTrue(facet != null, (Object)("GWT Facet not found for " + directory.getVirtualFile()));
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String packageName = psiPackage != null ? psiPackage.getQualifiedName() : "";
        String rootElementTypeName = (String)this.myRootElementType.get();
        String rootTagName = "div";
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)facet.getModule());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass rootElementType = psiFacade.findClass(rootElementTypeName, scope);
        if (rootElementType != null) {
            List<String> tagNames = GwtHtmlElementClassesFinder.getTagNames(rootElementType);
            if (!tagNames.isEmpty()) {
                rootTagName = tagNames.get(0);
            }
            if (InheritanceUtil.isInheritor((PsiClass)rootElementType, (boolean)true, (String)"com.google.gwt.user.client.ui.IsWidget")) {
                rootTagName = "g:" + rootElementType.getName();
            }
            isWidget = InheritanceUtil.isInheritor((PsiClass)rootElementType, (boolean)false, (String)"com.google.gwt.user.client.ui.Widget");
        } else {
            isWidget = false;
        }
        String qualifiedClassName = packageName.length() > 0 ? packageName + "." + name : name;
        PsiClass binderClass = CreateGwtUiBinderAction.createClassFromTemplate(directory, name, (FileType)StdFileTypes.JAVA, "GwtUiBinder.java", "QUALIFIED_NAME", qualifiedClassName, "ROOT_ELEMENT_TYPE", rootElementTypeName, "IS_WIDGET", isWidget);
        PsiElement binderFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)binderClass.getContainingFile());
        PsiFile uiXml = CreateGwtUiBinderAction.createFromTemplateInternal(directory, name, name + ".ui.xml", (FileType)StdFileTypes.XML, "GwtLayout.ui.xml", "ROOT_TAG_NAME", rootTagName);
        PsiElement[] psiElementArray = new PsiElement[]{binderFile, uiXml};
        if (psiElementArray == null) {
            CreateGwtUiBinderAction.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("label.text.enter.name.for.new.gwt.uibinder.class.and.ui.xml.file", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("dialog.title.create.new.gwt.uibinder.class.and.ui.xml.file", new Object[0]);
    }

    protected String getCommandName() {
        return GwtBundle.message("create.gwt.uibinder.command.name", new Object[0]);
    }

    public String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("action.name.create.gwt.uibinder.0.and.1.ui.xml.file", newName, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/actions/CreateGwtUiBinderAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/actions/CreateGwtUiBinderAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

