/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FtlSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ourMap;
    public static final TextAttributesKey FTL_DOT;
    public static final TextAttributesKey FTL_PARENTHESES;
    public static final TextAttributesKey FTL_BRACKETS;
    public static final TextAttributesKey FTL_BRACES;
    public static final TextAttributesKey FTL_OPERATION_SIGN;
    public static final TextAttributesKey FTL_STRING;
    public static final TextAttributesKey FTL_ESCAPE;
    public static final TextAttributesKey FTL_NUMBER;
    public static final TextAttributesKey FTL_KEYWORD;
    public static final TextAttributesKey FTL_COMMA;
    public static final TextAttributesKey FTL_SEMICOLON;
    public static final TextAttributesKey FTL_DIRECTIVE;
    public static final TextAttributesKey FTL_REFERENCE;
    public static final TextAttributesKey FTL_COMMENT;

    @NotNull
    public Lexer getHighlightingLexer() {
        FtlLexer ftlLexer = FtlLexer.createLexer();
        if (ftlLexer == null) {
            FtlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return ftlLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = FtlSyntaxHighlighter.pack((TextAttributesKey)ourMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            FtlSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        FTL_DOT = TextAttributesKey.createTextAttributesKey((String)"FTL_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        FTL_PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"FTL_PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        FTL_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"FTL_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        FTL_BRACES = TextAttributesKey.createTextAttributesKey((String)"FTL_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        FTL_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"FTL_OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        FTL_STRING = TextAttributesKey.createTextAttributesKey((String)"FTL_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        FTL_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"FTL_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        FTL_NUMBER = TextAttributesKey.createTextAttributesKey((String)"FTL_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        FTL_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"FTL_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        FTL_COMMA = TextAttributesKey.createTextAttributesKey((String)"FTL_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        FTL_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"FTL_SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        FTL_DIRECTIVE = TextAttributesKey.createTextAttributesKey((String)"FTL_DIRECTIVE", (TextAttributesKey)JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_NAME);
        FTL_REFERENCE = TextAttributesKey.createTextAttributesKey((String)"FTL_REFERENCE", (TextAttributesKey)JspHighlighterColors.JSP_ATTRIBUTE_NAME);
        FTL_COMMENT = TextAttributesKey.createTextAttributesKey((String)"FTL_COMMENT", (TextAttributesKey)JspHighlighterColors.JSP_COMMENT);
        ourMap = new THashMap();
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_DOT, (IElementType[])new IElementType[]{FtlElementTypes.DOT});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_PARENTHESES, (IElementType[])new IElementType[]{FtlElementTypes.LEFT_PAREN, FtlElementTypes.RIGHT_PAREN});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_BRACES, (IElementType[])new IElementType[]{FtlElementTypes.LEFT_BRACE, FtlElementTypes.RIGHT_BRACE});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_BRACKETS, (IElementType[])new IElementType[]{FtlElementTypes.LEFT_BRACKET, FtlElementTypes.RIGHT_BRACKET});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_OPERATION_SIGN, (IElementType[])FtlElementTypes.OPERATIONS.getTypes());
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_REFERENCE, (IElementType[])new IElementType[]{FtlElementTypes.IDENTIFIER});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_STRING, (IElementType[])new IElementType[]{FtlElementTypes.STRING_TEXT});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_STRING, (IElementType[])FtlElementTypes.QUOTES.getTypes());
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_ESCAPE, (IElementType[])new IElementType[]{FtlElementTypes.CHAR_ESCAPE});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_NUMBER, (IElementType[])new IElementType[]{FtlElementTypes.NUMBER});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_KEYWORD, (IElementType[])new IElementType[]{FtlElementTypes.BOOLEAN, FtlElementTypes.AS, FtlElementTypes.IN, FtlElementTypes.USING});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_COMMA, (IElementType[])new IElementType[]{FtlElementTypes.COMMA});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_SEMICOLON, (IElementType[])new IElementType[]{FtlElementTypes.SEMICOLON});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_NUMBER, (IElementType[])new IElementType[]{FtlElementTypes.QUESTION, FtlElementTypes.DOUBLE_QUESTION, FtlElementTypes.EXCLAM});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_DIRECTIVE, (IElementType[])new IElementType[]{FtlElementTypes.EL_START, FtlElementTypes.NUM_EL_START, FtlElementTypes.SQUARE_EL_START, FtlElementTypes.EL_END});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_DIRECTIVE, (IElementType[])new IElementType[]{FtlElementTypes.START_DIRECTIVE_START, FtlElementTypes.START_MACRO_START, FtlElementTypes.END_DIRECTIVE_START, FtlElementTypes.END_MACRO_START, FtlElementTypes.DIRECTIVE_END, FtlElementTypes.EMPTY_DIRECTIVE_END, FtlElementTypes.EMPTY_MACRO_END});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_DIRECTIVE, (IElementType[])FtlDirectiveTokenType.getAllDirectiveTokens().getTypes());
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_DIRECTIVE, (IElementType[])new IElementType[]{FtlElementTypes.COMMENT_START, FtlElementTypes.COMMENT_END});
        FtlSyntaxHighlighter.fillMap(ourMap, (TextAttributesKey)FTL_COMMENT, (IElementType[])new IElementType[]{FtlElementTypes.COMMENT_TEXT, FtlElementTypes.TERSE_COMMENT_START});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/freemarker/psi/files/FtlSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

