/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.SimpleMethodCallLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlAssignmentNamespace;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCallableLookupElement;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlVariantsProcessor;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlImportDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlDynamicMember;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlQualifiedReference
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    public static final Key<Boolean> RESOLVING_MACRO = Key.create((String)"RESOLVING_MACRO");
    private static final ResolveCache.PolyVariantResolver<FtlQualifiedReference> MY_RESOLVER = (expression, incompleteCode) -> expression.resolveInner();
    private final FtlReferenceQualifier myElement;
    @NonNls
    private static final Pattern NODE_CHILDREN_PATTERN = Pattern.compile("[@*]?(\\w*)(:(\\w*))?");

    protected FtlQualifiedReference(FtlReferenceQualifier element) {
        this.myElement = element;
    }

    @NotNull
    public FtlExpression getElement() {
        FtlReferenceQualifier ftlReferenceQualifier = this.myElement;
        if (ftlReferenceQualifier == null) {
            FtlQualifiedReference.$$$reportNull$$$0(0);
        }
        return ftlReferenceQualifier;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            FtlQualifiedReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public FtlQualifiedReference getParentReference() {
        PsiElement parent = this.getValidExpression().getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof FtlIndexExpression && this == ((FtlIndexExpression)parent).getQualifiedReference()) {
            return null;
        }
        return FtlPsiUtil.getReference(parent);
    }

    public PsiElement handleElementRename(@NotNull String newText) throws IncorrectOperationException {
        String propertyName;
        PsiElement target;
        if (newText == null) {
            FtlQualifiedReference.$$$reportNull$$$0(2);
        }
        CheckUtil.checkWritable((PsiElement)this.myElement);
        if (!this.isCall() && ((target = this.resolve()) instanceof PsiMethod || target instanceof FtlDynamicMember) && (propertyName = PropertyUtilBase.getPropertyName((String)newText)) != null) {
            newText = propertyName;
        }
        return this.doHandleElementRename(newText);
    }

    protected abstract PsiElement doHandleElementRename(String var1) throws IncorrectOperationException;

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            FtlQualifiedReference.$$$reportNull$$$0(3);
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this.myElement;
    }

    @Nullable
    public abstract String getReferenceName();

    @Nullable
    public FtlAssignmentDeclaration getAssignDeclaration() {
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof FtlNameValuePair) {
            FtlNameValuePair nameValuePair = (FtlNameValuePair)parent;
            FtlTokenType token = nameValuePair.getOperationToken();
            if (token != null && token != FtlElementTypes.EQ) {
                return null;
            }
            if (nameValuePair.getNameElement() == this.myElement && parent.getParent() instanceof FtlAssignDirective) {
                return ((FtlAssignDirective)parent.getParent()).getDeclarationFor(nameValuePair);
            }
        }
        return null;
    }

    @NotNull
    protected FtlResolveResult[] resolveInner() {
        FtlParameterDeclaration varargParameter;
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (FtlResolveResult.EMPTY_ARRAY == null) {
                FtlQualifiedReference.$$$reportNull$$$0(4);
            }
            return FtlResolveResult.EMPTY_ARRAY;
        }
        FtlVariantsProcessor<FtlResolveResult> processor = new FtlVariantsProcessor<FtlResolveResult>(this, referenceName){

            @Override
            protected FtlResolveResult execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                if (element instanceof BeanPropertyElement) {
                    return new FtlResolveResult((PsiNamedElement)((BeanPropertyElement)element).getMethod(), error, substitutor);
                }
                return new FtlResolveResult(element, error, substitutor);
            }
        };
        FtlAssignmentDeclaration assignmentDeclaration = this.getAssignDeclaration();
        if (assignmentDeclaration != null) {
            processor.execute((PsiElement)assignmentDeclaration, this.initialState());
        }
        this.processVariantsInner(processor, false, this.initialState());
        FtlResolveResult[] results = processor.toArray(FtlResolveResult.EMPTY_ARRAY);
        if (results.length == 0 && (varargParameter = this.getVarargParameter()) != null) {
            FtlResolveResult[] ftlResolveResultArray = new FtlResolveResult[]{new FtlResolveResult(varargParameter, JavaMethodResolveHelper.ErrorType.NONE, PsiSubstitutor.EMPTY)};
            if (ftlResolveResultArray == null) {
                FtlQualifiedReference.$$$reportNull$$$0(5);
            }
            return ftlResolveResultArray;
        }
        if (results == null) {
            FtlQualifiedReference.$$$reportNull$$$0(6);
        }
        return results;
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false, file);
        if (resolveResultArray == null) {
            FtlQualifiedReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @Nullable
    public final PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        if (results.length == 1) {
            return results[0].getElement();
        }
        FtlImplicitVariable implicit = null;
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!(element instanceof FtlVariable)) {
                return null;
            }
            if (!(element instanceof FtlImplicitVariable)) continue;
            if (implicit != null) {
                return null;
            }
            implicit = (FtlImplicitVariable)element;
        }
        return implicit;
    }

    @NotNull
    public Object[] getVariants() {
        FtlVariantsProcessor<PsiNamedElement> processor = new FtlVariantsProcessor<PsiNamedElement>(this, null){

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                return element;
            }
        };
        this.processVariantsInner(processor, true, this.initialState());
        final boolean isMacroParameter = this.isMacroParameter(true);
        Object[] elements = processor.toArray(PsiNamedElement.EMPTY_ARRAY);
        Object[] objectArray = ContainerUtil.map2Array((Object[])elements, LookupElement.class, (Function)new Function<PsiNamedElement, LookupElement>(){

            public LookupElement fun(PsiNamedElement element) {
                PsiType type;
                FtlVariable variable;
                FtlCallableType type2;
                if (element instanceof PsiMethod) {
                    return new SimpleMethodCallLookupElement((PsiMethod)element);
                }
                if (element instanceof FtlVariable && (type2 = FtlPsiUtil.asInstanceOf((variable = (FtlVariable)element).getType(), FtlCallableType.class)) != null) {
                    String name = variable.getName();
                    assert (name != null);
                    return new FtlCallableLookupElement(name, type2, false){

                        @Override
                        public void handleInsert(@NotNull InsertionContext context) {
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (type2.isMacro() && isMacroParameter) {
                                if (context.getCompletionChar() == ' ') {
                                    context.setAddCompletionChar(false);
                                }
                                TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)' ');
                            } else {
                                super.handleInsert(context);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/psi/FtlQualifiedReference$3$1", "handleInsert"));
                        }
                    };
                }
                String name = element.getName();
                assert (name != null);
                String lookupString = name;
                if (!FtlPsiUtil.isValidVariableName(name) && FtlQualifiedReference.this.myElement instanceof FtlReferenceExpression) {
                    String quoted = "['" + name + "']";
                    lookupString = FtlQualifiedReference.this.getReferenceQualifier() == null ? ".vars" + quoted : quoted;
                }
                LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)element, (String)lookupString);
                lookupElement = lookupElement.withLookupString(name).withIcon(element.getIcon(0));
                if (element instanceof FtlVariable) {
                    FtlType type3 = ((FtlVariable)element).getType();
                    if (type3 != null) {
                        lookupElement = lookupElement.withTypeText(type3.getPresentableText());
                    }
                } else if (element instanceof BeanPropertyElement && (type = ((BeanPropertyElement)element).getPropertyType()) != null) {
                    lookupElement = lookupElement.withTypeText(type.getPresentableText());
                }
                if (element instanceof FtlParameterDeclaration && isMacroParameter) {
                    return TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)new CharTailType('='));
                }
                if (element instanceof FtlImportDirective && !(FtlQualifiedReference.this.myElement.getParent() instanceof FtlAssignmentNamespace)) {
                    return TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)TailType.DOT);
                }
                return lookupElement;
            }
        });
        if (objectArray == null) {
            FtlQualifiedReference.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    public boolean isMacroParameter(boolean forCompletion) {
        return this.getMacroReference(forCompletion) != null;
    }

    @Nullable
    private FtlCallableType getMacroType(boolean forCompletion) {
        FtlCallableType type;
        FtlExpression expression;
        if (this.getReferenceQualifier() == null && (expression = this.getMacroReference(forCompletion)) != null && (type = FtlPsiUtil.asInstanceOf(expression.getType(), FtlCallableType.class)) != null && type.isMacro()) {
            return type;
        }
        return null;
    }

    @Nullable
    private FtlParameterDeclaration getVarargParameter() {
        FtlCallableType macroType = this.getMacroType(false);
        return macroType != null ? macroType.getVarargParameter() : null;
    }

    protected void processVariantsInner(PsiScopeProcessor processor, boolean forCompletion, ResolveState state) {
        PsiElement psiElement;
        if (this.isMacroClosingName()) {
            FtlSignatureDirective directive;
            PsiElement parent = this.getExpressionParent();
            FtlSignatureDirective ftlSignatureDirective = directive = parent instanceof FtlMacro ? ((FtlMacro)parent).resolveMacro() : null;
            if (directive != null) {
                processor.execute((PsiElement)directive, ResolveState.initial());
            }
            return;
        }
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            FtlCallableType type = this.getMacroType(forCompletion);
            if (type != null) {
                boolean onlyMacroParam;
                THashSet definedParameters = new THashSet();
                PsiElement parent = this.myElement.getParent();
                boolean bl = onlyMacroParam = forCompletion && parent instanceof FtlNameValuePair;
                if (onlyMacroParam) {
                    FtlNameValuePair pair;
                    FtlArgumentList list = (FtlArgumentList)parent.getParent();
                    FtlNameValuePair[] ftlNameValuePairArray = list.getNamedArguments();
                    int n = ftlNameValuePairArray.length;
                    for (int i = 0; i < n && (pair = ftlNameValuePairArray[i]) != parent; ++i) {
                        definedParameters.add(pair.getName());
                    }
                }
                for (FtlParameter variable : type.getParameters()) {
                    if (definedParameters.contains(variable.getName()) || processor.execute((PsiElement)variable, state)) continue;
                    return;
                }
                if (onlyMacroParam) {
                    return;
                }
            }
            PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, null, (ResolveState)this.initialState());
            return;
        }
        FtlType type = qualifier.getType();
        if (type != null && !type.processDeclarations(processor, this.myElement, state)) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference instanceof FtlQualifiedReference && (psiElement = reference.resolve()) != null && !psiElement.processDeclarations(processor, state, null, (PsiElement)this.myElement)) {
            return;
        }
    }

    public boolean isMacroClosingName() {
        return PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this.getElement())) == FtlElementTypes.END_MACRO_START;
    }

    @Nullable
    private FtlExpression getMacroReference(boolean forCompletion) {
        FtlArgumentList list;
        FtlNameValuePair nameValuePair;
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof FtlNameValuePair && (nameValuePair = (FtlNameValuePair)parent).getNameElement() == this.myElement && parent.getParent() instanceof FtlArgumentList && parent.getParent().getParent() instanceof FtlMacro) {
            return ((FtlMacro)parent.getParent().getParent()).getMacroReference();
        }
        if (forCompletion && parent instanceof FtlArgumentList && (list = (FtlArgumentList)parent).isPositional() && list.getPositionalArguments()[0] == this.myElement && parent.getParent() instanceof FtlMacro) {
            return ((FtlMacro)parent.getParent()).getMacroReference();
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FtlQualifiedReference.$$$reportNull$$$0(9);
        }
        PsiManager manager = this.myElement.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (manager.areElementsEquivalent(element, target)) {
                return true;
            }
            if (target instanceof BeanPropertyElement && manager.areElementsEquivalent(element, (PsiElement)((BeanPropertyElement)target).getMethod())) {
                return true;
            }
            if (!(target instanceof FtlDynamicMember) || !manager.areElementsEquivalent(element, (PsiElement)((FtlDynamicMember)target).getDeclaration())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public abstract FtlReferenceQualifier getReferenceQualifier();

    public LocalQuickFix[] getQuickFixes() {
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ResolveResult[] results = this.multiResolve(false);
        if (results.length != 1) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ResolveResult resolveResult = results[0];
        if (!(resolveResult instanceof FtlResolveResult)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlResolveResult result = (FtlResolveResult)resolveResult;
        if (result.getResolveError() != JavaMethodResolveHelper.ErrorType.STATIC) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlPsiType type = FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlPsiType.class);
        if (type == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlQualifiedReference reference = FtlPsiUtil.getReference(qualifier);
        if (reference == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        final PsiElement var = reference.resolve();
        if (!(var instanceof FtlImplicitVariable)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFix(){

            @Nls
            @NotNull
            public String getName() {
                String string = FreeMarkerBundle.message("quickfix.convert.to.instance", ((FtlImplicitVariable)var).getName());
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Convert to instance type" == null) {
                    4.$$$reportNull$$$0(1);
                }
                return "Convert to instance type";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (!var.isValid()) {
                    return;
                }
                PsiElement comment = var.getNavigationElement();
                if (!comment.isValid()) {
                    return;
                }
                int offset = FtlReferenceContributor.getTypeEndOffset(comment.getText());
                if (offset < 0) {
                    return;
                }
                offset += comment.getTextRange().getStartOffset();
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
                assert (document != null);
                if (!StringUtil.endsWith((CharSequence)document.getCharsSequence().subSequence(0, offset), (CharSequence)".static")) {
                    return;
                }
                document.deleteString(offset - ".static".length(), offset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/freemarker/psi/FtlQualifiedReference$4";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/freemarker/psi/FtlQualifiedReference$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
    }

    @Nullable
    private String getStaticErrorMessage() {
        PsiElement element = this.resolve();
        if (element instanceof PsiMember) {
            return FreeMarkerBundle.message("error.static.member.expected", new Object[0]);
        }
        return null;
    }

    public String getUnresolvedMessage(JavaMethodResolveHelper.ErrorType resolveError) {
        String referenceName = this.getReferenceName();
        if (this.myElement.getParent() instanceof FtlMacro) {
            return FreeMarkerBundle.message("error.cannot.resolve.macro", referenceName);
        }
        FtlExpression expression = this.getMacroReference(false);
        if (expression != null) {
            return FreeMarkerBundle.message("error.cannot.resolve.parameter.0.of.macro.1", referenceName, expression.getText());
        }
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        boolean isCall = this.isCall();
        if (qualifier != null) {
            PsiClass type = FtlPsiUtil.resolveClassInType(qualifier.getType());
            if (type != null) {
                String message;
                String typeName = type.getQualifiedName();
                if (isCall) {
                    switch (resolveError) {
                        case RESOLVE: {
                            Ref containsNulls = Ref.create((Object)false);
                            String s = StringUtil.join((Object[])((FtlMethodCallExpression)this.myElement.getParent()).getArgumentTypes(), psiType -> {
                                if (psiType == null) {
                                    containsNulls.set((Object)true);
                                    return "???";
                                }
                                return psiType.getPresentableText();
                            }, (String)", ");
                            if (((Boolean)containsNulls.get()).booleanValue()) {
                                return FreeMarkerBundle.message("error.multiple.overloaded.methods", referenceName + "(" + s + ")");
                            }
                            return FreeMarkerBundle.message("error.no.applicable.method", referenceName, typeName, "(" + s + ")");
                        }
                        case STATIC: {
                            String message2 = this.getStaticErrorMessage();
                            if (message2 != null) {
                                return message2;
                            }
                        }
                        case NONE: {
                            return FreeMarkerBundle.message("error.cannot.resolve.method.of", referenceName, typeName);
                        }
                    }
                }
                if (resolveError == JavaMethodResolveHelper.ErrorType.STATIC && (message = this.getStaticErrorMessage()) != null) {
                    return message;
                }
                return FreeMarkerBundle.message("error.cannot.resolve.field.of", referenceName, typeName);
            }
            if (qualifier.getType() == null) {
                if (isCall) {
                    return FreeMarkerBundle.message("error.cannot.resolve.method", referenceName);
                }
                return FreeMarkerBundle.message("error.cannot.resolve.field", referenceName);
            }
        }
        if (isCall) {
            return FreeMarkerBundle.message("error.cannot.resolve.function.0", referenceName);
        }
        if (resolveError == JavaMethodResolveHelper.ErrorType.RESOLVE) {
            return FreeMarkerBundle.message("variable.may.be.undefined", referenceName);
        }
        return FreeMarkerBundle.message("error.cannot.resolve.variable.0", referenceName);
    }

    public boolean isCall() {
        return this.getExpressionParent() instanceof FtlMethodCallExpression;
    }

    @Nullable
    public FtlType getType() {
        if (this.isNodeChildrenAccessor()) {
            return new FtlCollectionType(FtlNodeType.INSTANCE);
        }
        LinkedHashSet types = ContainerUtil.newLinkedHashSet();
        for (ResolveResult result : this.multiResolve(false)) {
            FtlReferenceQualifier qualifier;
            PsiMethod method;
            PsiSubstitutor substitutor = ((FtlResolveResult)result).getSubstitutor();
            PsiElement element = result.getElement();
            if (element instanceof PsiMethod && "clone".equals((method = (PsiMethod)element).getName()) && method.getParameterList().getParametersCount() == 0 && (qualifier = this.getReferenceQualifier()) != null) {
                types.add(qualifier.getType());
                continue;
            }
            for (FtlType type : FtlPsiUtil.getAllTypeComponents(FtlPsiUtil.getFtlTypeByPsiElement(element, substitutor), FtlType.class)) {
                FtlCallableType callableType;
                if (!this.isCall() && type instanceof FtlCallableType && !(callableType = (FtlCallableType)type).isMacro()) {
                    type = callableType.getResultType();
                }
                types.add(type);
            }
            if (!(element instanceof FtlLoopVariable) || !((FtlLoopVariable)element).getSuffix().isEmpty() || !(this.getExpressionParent() instanceof FtlBuiltIn)) continue;
            types.add(FtlLoopVariableType.INSTANCE);
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            return (FtlType)types.iterator().next();
        }
        return new FtlCompositeType(types.toArray(new FtlType[0]));
    }

    public FtlCallableType[] getCallableCandidates() {
        final String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return FtlCallableType.EMPTY_ARRAY;
        }
        FtlVariantsProcessor<FtlCallableType> processor = new FtlVariantsProcessor<FtlCallableType>(this, null){

            @Override
            protected FtlCallableType execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                if (!referenceName.equals(element.getName())) {
                    return null;
                }
                if (element instanceof PsiMethod) {
                    return new FtlMethodType((PsiMethod)element, substitutor);
                }
                if (element instanceof FtlSignatureDirective) {
                    return ((FtlSignatureDirective)element).getType();
                }
                return null;
            }
        };
        this.processVariantsInner(processor, false, this.initialState());
        return processor.toArray(FtlCallableType.EMPTY_ARRAY);
    }

    private ResolveState initialState() {
        return ResolveState.initial().put(RESOLVING_MACRO, (Object)FtlQualifiedReference.isMacroCall(this.myElement));
    }

    public static boolean isMacroCall(PsiElement place) {
        FtlMacro macro = (FtlMacro)PsiTreeUtil.getParentOfType((PsiElement)place, FtlMacro.class);
        return macro != null && PsiTreeUtil.isAncestor((PsiElement)macro.getMacroReference(), (PsiElement)place, (boolean)false);
    }

    public boolean isNodeChildrenAccessor() {
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            return false;
        }
        if (FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlNodeType.class) == null) {
            return false;
        }
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        if ("*".equals(referenceName) || "**".equals(referenceName) || "@@".equals(referenceName) || "@*".equals(referenceName)) {
            return true;
        }
        if (referenceName.startsWith("@@")) {
            return false;
        }
        return NODE_CHILDREN_PATTERN.matcher(referenceName).matches();
    }

    public PsiElement getExpressionParent() {
        return this.myElement.getParent();
    }

    @NotNull
    public FtlExpression getValidExpression() {
        if (this.isCall()) {
            FtlExpression ftlExpression = (FtlExpression)this.getExpressionParent();
            if (ftlExpression == null) {
                FtlQualifiedReference.$$$reportNull$$$0(10);
            }
            return ftlExpression;
        }
        FtlReferenceQualifier ftlReferenceQualifier = this.myElement;
        if (ftlReferenceQualifier == null) {
            FtlQualifiedReference.$$$reportNull$$$0(11);
        }
        return ftlReferenceQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlQualifiedReference)) {
            return false;
        }
        FtlQualifiedReference that = (FtlQualifiedReference)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlQualifiedReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlQualifiedReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

