/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.FtlBuiltIns;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.FtlPathGenerator;
import com.intellij.freemarker.FtlPsiTypeCanonicalLookupElement;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.KeywordCompletionProvider;
import com.intellij.freemarker.inspections.FtlWellformednessInspection;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCallableLookupElement;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlFileReference;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class FtlCompletionContributor
extends CompletionContributor {
    private static final Key<FtlDirective> DIRECTIVE_KEY = Key.create((String)"FtlDirective");
    private static final PsiElementPattern.Capture<PsiElement> FILE_REFERENCE_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(FtlStringLiteral.class).withReference(FtlFileReference.class));

    public FtlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.START_DIRECTIVE_START).withParent((ElementPattern)PlatformPatterns.psiElement(FtlDirective.class).save(DIRECTIVE_KEY))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (String name : FtlDirectiveTokenType.getAllDirectiveNames()) {
                    if (FtlWellformednessInspection.getWellformednessProblem(name, (FtlDirective)((Object)context.get(DIRECTIVE_KEY)), true) != null) continue;
                    result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)name).bold(), (TailType)TailType.SPACE));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"comment").bold());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiFile file = parameters.getPosition().getContainingFile();
                FileViewProvider viewProvider = file.getViewProvider();
                CharSequence contents = viewProvider.getContents();
                int offset = parameters.getOffset() - result.getPrefixMatcher().getPrefix().length();
                if (offset < 1) {
                    return;
                }
                char directiveChar = contents.charAt(offset - 1);
                if (directiveChar == '#' || directiveChar == '@') {
                    --offset;
                    result = result.withPrefixMatcher(directiveChar + result.getPrefixMatcher().getPrefix());
                }
                if (offset > 1 && contents.charAt(offset - 1) == '/') {
                    FtlDirectiveStyle directiveStyle = FtlLexer.guessDirectiveStyle(contents);
                    if (contents.charAt(offset - 2) == directiveStyle.getDirectiveStartChar()) {
                        PsiElement ftlLeaf = viewProvider.findElementAt(offset - 1, viewProvider.getBaseLanguage());
                        List directives = FtlCompletionContributor.findDirectivesToClose(ftlLeaf);
                        for (int i = 0; i < directives.size(); ++i) {
                            FtlXmlTag tag = (FtlXmlTag)((Object)directives.get(i));
                            LookupElementBuilder item = LookupElementBuilder.create((String)tag.getDirectiveTagName()).withBoldness(tag instanceof FtlDirective);
                            item = TailTypeDecorator.withTail((LookupElement)item, (TailType)new CharTailType(directiveStyle.getDirectiveEndChar()));
                            item = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)item);
                            item = PrioritizedLookupElement.withPriority((LookupElement)item, (double)(directives.size() - i));
                            result.addElement((LookupElement)item);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.IDENTIFIER).withParent(FtlBuiltIn.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                FtlBuiltIn builtIn = (FtlBuiltIn)parameters.getPosition().getParent();
                List<FtlBuiltInDescriptor> list = FtlBuiltIns.getBuiltIns(builtIn.getQualifier(), null);
                boolean camelCase = FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFtlFile());
                for (FtlBuiltInDescriptor descriptor : list) {
                    String name;
                    FtlType type = descriptor.getType(builtIn);
                    String string = name = camelCase ? descriptor.getCamelCaseName() : descriptor.getSnakeCaseName();
                    if (type != null) {
                        List<FtlType> allTypes = FtlPsiUtil.getAllTypeComponents(type, FtlType.class);
                        for (FtlType ftlType : allTypes) {
                            if (ftlType instanceof FtlCallableType) {
                                result.addElement((LookupElement)new FtlCallableLookupElement(name, (FtlCallableType)ftlType, true));
                                continue;
                            }
                            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON).withTypeText(type.getPresentableText()));
                        }
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.IDENTIFIER).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)FtlCompositeElementTypes.ATTRIBUTE_NAME).withParent((ElementPattern)PlatformPatterns.psiElement(FtlNameValuePair.class).withParent(FtlDirective.class))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                THashSet attrNames;
                FtlNameValuePair attr;
                FtlDirective directive;
                if (parameters == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ("ftl".equals((directive = (FtlDirective)(attr = (FtlNameValuePair)parameters.getPosition().getParent().getParent()).getParent()).getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.FTL_ATTRIBUTE_NAMES);
                } else if ("include".equals(directive.getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.INCLUDE_ATTRIBUTE_NAMES);
                } else if ("setting".equals(directive.getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.VALID_SETTING_NAMES);
                } else {
                    return;
                }
                for (PsiElement element : directive.getChildren()) {
                    if (element == attr) break;
                    if (!(element instanceof FtlNameValuePair)) continue;
                    attrNames.remove(((FtlNameValuePair)element).getName());
                }
                boolean camelCase = FtlPsiUtil.isUsingCamelCase(directive.getContainingFtlFile());
                for (String name : attrNames) {
                    if (camelCase && name.contains("_") || !camelCase && StringUtil.hasUpperCaseChar((String)name)) continue;
                    result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)name), (TailType)new CharTailType('=')));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$4";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, FtlReferenceContributor.FTL_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                String shortcut;
                if (parameters == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    5.$$$reportNull$$$0(2);
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                String text = element.getText();
                int typeStart = FtlReferenceContributor.getTypeStartOffset(text);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (offset >= typeStart && FtlReferenceContributor.getTypeEndOffset(text) > offset && !text.contains("name=\"\"") && StringUtil.isNotEmpty((String)(shortcut = FtlCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                    result.addLookupAdvertisement(FreeMarkerBundle.message("smart.completion.inference.hint", shortcut));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$5";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.SMART, FtlReferenceContributor.FTL_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    6.$$$reportNull$$$0(2);
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                String text = element.getText();
                int typeStart = FtlReferenceContributor.getTypeStartOffset(text);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (offset >= typeStart && FtlReferenceContributor.getTypeEndOffset(text) > offset) {
                    CompletionResultSet result = _result.withPrefixMatcher(text.substring(typeStart, offset));
                    FtlFile originalFile = (FtlFile)parameters.getOriginalFile();
                    PsiComment comment = (PsiComment)originalFile.findElementAt(element.getTextRange().getStartOffset());
                    assert (comment != null);
                    FtlVariable originalVariable = null;
                    if (comment.getParent() instanceof FtlSignatureDirective) {
                        Matcher matcher = FtlFile.VAR_DECL_PATTERN.matcher(comment.getText());
                        if (matcher.matches()) {
                            originalVariable = ((FtlSignatureDirective)comment.getParent()).findParameter(matcher.group(1));
                        }
                    } else {
                        originalVariable = originalFile.findImplicitVariable(comment);
                    }
                    if (originalVariable == null || StringUtil.isEmptyOrSpaces((String)originalVariable.getName())) {
                        return;
                    }
                    Couple pair = FtlCompletionContributor.inferVariableType(originalVariable);
                    FtlCompletionContributor.addInferredTypeItems(element, result, false, (Collection)pair.first);
                    FtlCompletionContributor.addInferredTypeItems(element, result, true, (Collection)pair.second);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$6";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(null, FtlReferenceContributor.FTL_ROOT_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                PsiComment element;
                Module module;
                if (parameters == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    7.$$$reportNull$$$0(2);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(element = (PsiComment)parameters.getPosition()))) == null) {
                    return;
                }
                VirtualFile currentFile = parameters.getOriginalFile().getVirtualFile();
                String text = element.getText();
                int pathStart = text.indexOf(34);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (pathStart > 0 && offset >= pathStart && text.indexOf(34, pathStart + 1) > offset) {
                    if (parameters.getCompletionType() == CompletionType.CLASS_NAME) {
                        return;
                    }
                    if (parameters.getCompletionType() == CompletionType.BASIC) {
                        String shortcut = FtlCompletionContributor.getActionShortcut((String)"SmartTypeCompletion");
                        if (StringUtil.isNotEmpty((String)shortcut)) {
                            _result.addLookupAdvertisement(FreeMarkerBundle.message("smart.completion.roots.hint", shortcut));
                        }
                        return;
                    }
                    CompletionResultSet result = _result.withPrefixMatcher(text.substring(pathStart + 1, offset));
                    MultiMap name2Path = new MultiMap();
                    MultiMap name2File = new MultiMap();
                    FileBasedIndex.ValueProcessor processor = (file, value) -> {
                        name2File.putValue((Object)FtlCompletionContributor.removeLocale(file.getNameWithoutExtension()), (Object)file.getParent());
                        for (String s : value.includes) {
                            int sep = s.lastIndexOf(47);
                            String parentPath = sep < 0 ? "" : s.substring(0, sep);
                            String fileName = s.substring(sep + 1);
                            String nameWithoutExtension = StringUtil.getPackageName((String)fileName);
                            name2Path.putValue((Object)FtlCompletionContributor.removeLocale(nameWithoutExtension), (Object)parentPath);
                        }
                        return true;
                    };
                    FtlCompletionContributor.processAllFtlFiles(module, (FileBasedIndex.ValueProcessor<? super FtlIndexInfo>)processor);
                    for (String file2 : name2Path.keySet()) {
                        Iterator iterator = name2Path.get((Object)file2).iterator();
                        while (iterator.hasNext()) {
                            String _parentPath;
                            String parentPath = _parentPath = (String)iterator.next();
                            int parentsCount = 0;
                            while (parentPath.startsWith("/..")) {
                                --parentsCount;
                                parentPath = parentPath.substring(3);
                            }
                            for (VirtualFile parentFile : name2File.get((Object)file2)) {
                                String relPath;
                                if (!parentFile.getPath().endsWith(parentPath)) continue;
                                VirtualFile rootCandidate = parentFile;
                                int i = -1;
                                while (rootCandidate != null && (i = parentPath.indexOf(47, i + 1)) >= 0) {
                                    if (parentsCount < 0) {
                                        ++parentsCount;
                                        continue;
                                    }
                                    rootCandidate = rootCandidate.getParent();
                                }
                                if (rootCandidate == null || (relPath = FtlFileReferenceDirective.getRelativePath(currentFile, rootCandidate)) == null) continue;
                                result.addElement((LookupElement)LookupElementBuilder.create((String)relPath).withIcon(PlatformIcons.FOLDER_ICON));
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$7";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)FILE_REFERENCE_PATTERN, new AllFtlFilesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)FILE_REFERENCE_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                String shortcut;
                if (parameters == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    8.$$$reportNull$$$0(2);
                }
                if (StringUtil.isNotEmpty((String)(shortcut = FtlCompletionContributor.getActionShortcut((String)"CodeCompletion")))) {
                    _result.addLookupAdvertisement(FreeMarkerBundle.message("global.completion.all.ftl.files.hint", shortcut));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$8";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})), new KeywordCompletionProvider());
    }

    @NotNull
    private static List<FtlXmlTag> findDirectivesToClose(PsiElement ftlLeaf) {
        ArrayList<FtlXmlTag> result = new ArrayList<FtlXmlTag>();
        FtlWellformednessInspection.processParentDirectives(ftlLeaf, (Processor<? super FtlXmlTag>)((Processor)directive -> {
            boolean mustBeClosed = directive.needsClosing();
            boolean optionallyClosed = FtlDirectiveType.isDirective((PsiElement)directive, "sep");
            if ((mustBeClosed || optionallyClosed) && directive.getEndTagNameElement() == null) {
                result.add((FtlXmlTag)((Object)directive));
                return optionallyClosed;
            }
            return true;
        }));
        ArrayList<FtlXmlTag> arrayList = result;
        if (arrayList == null) {
            FtlCompletionContributor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        FtlStringLiteral literal;
        if (context == null) {
            FtlCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((literal = (FtlStringLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), FtlStringLiteral.class, (boolean)false)) != null) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    public static LookupElement createFileReferenceLookupItem(String lookupString) {
        return LookupElementBuilder.create((String)lookupString).withIcon(FtlFileType.INSTANCE.getIcon());
    }

    public static void processAllFtlFiles(@NotNull Module module, FileBasedIndex.ValueProcessor<? super FtlIndexInfo> processor) {
        if (module == null) {
            FtlCompletionContributor.$$$reportNull$$$0(2);
        }
        Map ftlFiles = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                FtlCompletionContributor.$$$reportNull$$$0(8);
            }
            LinkedHashMap result = new LinkedHashMap();
            FileBasedIndex.getInstance().processValues(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.DATA, null, (file, value) -> {
                result.put(file, value);
                return true;
            }, GlobalSearchScope.moduleScope((Module)module));
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        for (Map.Entry entry : ftlFiles.entrySet()) {
            if (processor.process((VirtualFile)entry.getKey(), entry.getValue())) continue;
            return;
        }
    }

    private static String removeLocale(String name) {
        int i = name.indexOf(95);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static void addInferredTypeItems(PsiComment element, CompletionResultSet result, boolean asStatic, Collection<String> typeNames) {
        for (String typeName : typeNames) {
            try {
                PsiType psiType = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createTypeFromText(typeName, (PsiElement)element);
                result.addElement((LookupElement)new FtlPsiTypeCanonicalLookupElement(psiType, asStatic));
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
    }

    @NotNull
    private static Couple<Collection<String>> inferVariableType(FtlVariable variable) {
        Couple<Collection<String>> couple = FtlCompletionContributor.inferVariableType((Query<PsiReference>)ReferencesSearch.search((PsiElement)variable));
        if (couple == null) {
            FtlCompletionContributor.$$$reportNull$$$0(3);
        }
        return couple;
    }

    @NotNull
    public static Couple<Collection<String>> inferVariableType(Query<PsiReference> query) {
        Ref intersection = Ref.create(null);
        Ref intersectionStatic = Ref.create(null);
        Ref onlyScalar = Ref.create(null);
        ArrayList parentReferences = new ArrayList();
        ArrayList loopVariables = new ArrayList();
        query.forEach(psiReference -> {
            FtlQualifiedReference parentReference;
            if (!(psiReference instanceof FtlQualifiedReference)) {
                return true;
            }
            FtlQualifiedReference reference = (FtlQualifiedReference)psiReference;
            PsiElement parent = reference.getValidExpression().getParent();
            if (parent instanceof FtlInterpolation) {
                if (onlyScalar.isNull()) {
                    onlyScalar.set((Object)Boolean.TRUE);
                }
            } else {
                onlyScalar.set((Object)Boolean.FALSE);
            }
            if ((parentReference = reference.getParentReference()) != null) {
                String referenceName = parentReference.getReferenceName();
                if (StringUtil.isNotEmpty((String)referenceName)) {
                    parentReferences.add(parentReference);
                }
            } else if (parent instanceof FtlListDirective) {
                loopVariables.addAll(((FtlListDirective)parent).getMainLoopVariables());
            }
            return true;
        });
        if (onlyScalar.get() == Boolean.TRUE) {
            List<String> classNames = Arrays.asList("java.lang.String", "java.util.Date", "java.lang.Number");
            Couple couple = Couple.of(classNames, Collections.emptyList());
            if (couple == null) {
                FtlCompletionContributor.$$$reportNull$$$0(4);
            }
            return couple;
        }
        for (FtlQualifiedReference parentReference : parentReferences) {
            Couple<Set<String>> classes = FtlCompletionContributor.suggestClassesWithMember(parentReference);
            FtlCompletionContributor.intersect((Set)classes.first, (Ref<Set<String>>)intersection);
            FtlCompletionContributor.intersect((Set)classes.second, (Ref<Set<String>>)intersectionStatic);
        }
        for (FtlLoopVariable loopVariable : loopVariables) {
            THashSet collections = new THashSet();
            for (String type : (Collection)FtlCompletionContributor.inferVariableType((FtlVariable)loopVariable).first) {
                collections.add("java.util.Collection<" + type + ">");
                collections.add(type + "[]");
            }
            FtlCompletionContributor.intersect((Set<String>)collections, (Ref<Set<String>>)intersection);
        }
        Couple couple = Couple.of(intersection.isNull() ? Collections.emptySet() : (Collection)intersection.get(), intersectionStatic.isNull() ? Collections.emptySet() : (Collection)intersectionStatic.get());
        if (couple == null) {
            FtlCompletionContributor.$$$reportNull$$$0(5);
        }
        return couple;
    }

    public static Couple<Set<String>> suggestClassesWithMember(FtlQualifiedReference reference) {
        PsiFile file = reference.getElement().getContainingFile();
        String referenceName = reference.getReferenceName();
        assert (referenceName != null);
        THashSet classes = new THashSet();
        THashSet classesStatic = new THashSet();
        if (reference.isCall()) {
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
        } else {
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classes, (boolean)false, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classesStatic, (boolean)false, (boolean)true);
            String getter = PropertyUtilBase.suggestGetterName((String)referenceName, null);
            CreateFromUsageUtils.addClassesWithMember((String)getter, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)getter, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
            String isGetter = PropertyUtilBase.suggestGetterName((String)referenceName, (PsiType)PsiType.BOOLEAN);
            CreateFromUsageUtils.addClassesWithMember((String)isGetter, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)isGetter, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
        }
        return Couple.of((Object)classes, (Object)classesStatic);
    }

    private static void intersect(Set<String> classes, Ref<Set<String>> to) {
        if (to.isNull()) {
            to.set(classes);
        } else {
            ((Set)to.get()).retainAll(classes);
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            FtlCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            FtlCompletionContributor.$$$reportNull$$$0(7);
        }
        if (!FtlPsiUtil.hasFtlViewProvider(parameters.getOriginalFile())) {
            return;
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/FtlCompletionContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectivesToClose";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/FtlCompletionContributor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inferVariableType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAllFtlFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllFtlFiles$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AllFtlFilesProvider
    extends CompletionProvider<CompletionParameters> {
        private AllFtlFilesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
            if (parameters == null) {
                AllFtlFilesProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                AllFtlFilesProvider.$$$reportNull$$$0(1);
            }
            if (_result == null) {
                AllFtlFilesProvider.$$$reportNull$$$0(2);
            }
            if (parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() < 2) {
                return;
            }
            _result.stopHere();
            FtlStringLiteral literal = (FtlStringLiteral)parameters.getPosition().getParent();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return;
            }
            int endOffsetInLiteral = parameters.getOffset() - literal.getTextRange().getStartOffset();
            String prefix = literal.getText().substring(literal.getValueStartOffset(), endOffsetInLiteral);
            CompletionResultSet result = _result.withPrefixMatcher(prefix);
            PsiFile file = parameters.getOriginalFile();
            FtlPathGenerator generator = new FtlPathGenerator(file, module);
            VirtualFile currentFile = file.getVirtualFile();
            FtlCompletionContributor.processAllFtlFiles(module, (FileBasedIndex.ValueProcessor<? super FtlIndexInfo>)((FileBasedIndex.ValueProcessor)(file1, value) -> {
                if (currentFile.equals(file1)) {
                    return true;
                }
                String best = generator.generatePath(file1);
                if (best != null) {
                    result.addElement(FtlCompletionContributor.createFileReferenceLookupItem(best));
                }
                return true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "_result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlCompletionContributor$AllFtlFilesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

