/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgent;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudLocation;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentRuntime;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.cloud.agent.CloudListWrapper;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentBase;
import com.intellij.remoteServer.agent.util.CloudAgentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudApplicationRuntimeImpl;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CFServerRuntimeInstanceBase<CA extends CFCloudAgent>
extends CloudServerRuntimeInstance<CFDeploymentConfiguration, CA, CFServerConfiguration> {
    private static final Logger LOG = Logger.getInstance(CFServerRuntimeInstanceBase.class);
    private static final String SPECIFICS_JAR_PATH = "specifics/cloudFoundrySpecifics.jar";

    protected CFServerRuntimeInstanceBase(CFServerConfiguration configuration, ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles, String specificsModuleName, Class<CA> agentInterface, String agentClassName) throws Exception {
        if (libraryFiles == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(0);
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Arrays.asList(CFCloudAgentBase.class, ILogger.class, CloudListWrapper.class), specificsModuleName, SPECIFICS_JAR_PATH, agentInterface, agentClassName);
    }

    public void connect(final ServerConnector.ConnectionCallback<CFDeploymentConfiguration> callback) {
        ((CFCloudAgent)this.getAgent()).connect((CFCloudAgentConfiguration)this.getConfiguration(), new CloudAgentCallback(){

            public void connected() {
                callback.connected((ServerRuntimeInstance)CFServerRuntimeInstanceBase.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        }, new CloudAgentLogger(){

            public void debugEx(Exception e) {
                LOG.debug((Throwable)e);
            }

            public void debug(String message) {
                LOG.debug(message);
            }
        }, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, @NotNull CFDeploymentConfiguration configuration) {
        String manifestApplicationName;
        if (source == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(2);
        }
        String string = StringUtil.isEmpty((String)(manifestApplicationName = configuration.getManifest().getCurrentApplication())) ? CFCloudLocation.NAME_PROVIDER.getDeploymentName(source) : manifestApplicationName;
        if (string == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void deploy(@NotNull DeploymentTask<CFDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        DeploymentSource deploymentSource;
        File source;
        if (task == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            CFServerRuntimeInstanceBase.$$$reportNull$$$0(6);
        }
        if ((source = (deploymentSource = task.getSource()).getFile()) == null) {
            callback.errorOccurred(JavaeeBundle.getText((String)"ServerInstance.invalid.deployment.source", (Object[])new Object[]{deploymentSource.getPresentableName()}));
            return;
        }
        String deploymentName = this.getDeploymentName(deploymentSource, (CFDeploymentConfiguration)task.getConfiguration());
        List<String> appUrls = ((CFServerConfiguration)this.getConfiguration()).getLocationAppUrls(task);
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                CFServerRuntimeInstanceBase.$$$reportNull$$$0(7);
            }
            if (logManager == null) {
                CFServerRuntimeInstanceBase.$$$reportNull$$$0(8);
            }
            if (callback == null) {
                CFServerRuntimeInstanceBase.$$$reportNull$$$0(9);
            }
            ((CFDeploymentConfiguration)task.getConfiguration()).getManifest().validate();
            new CFDeploymentRuntime(this.getTaskExecutor(), (CFCloudAgent)this.getAgent(), deploymentName, appUrls, task, logManager).deploy(callback);
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> ((CFCloudAgent)this.getAgent()).disconnect());
    }

    public CFAppSettingsRange getAppSettingsRange() throws ServerRuntimeException {
        return (CFAppSettingsRange)this.getAgentTaskExecutor().execute(() -> new CFAppSettingsRangeImpl(((CFCloudAgent)this.getAgent()).getAppSettingsRange()));
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudApplicationRuntimeImpl(this.getTaskExecutor(), (CloudAgentBase)this.getAgent(), application);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentName";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deploy$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

