/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.base.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.AgentDeploymentException;
import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentApplicationBase;
import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplication;
import com.intellij.javaee.util.AgentDeployStateChecker;
import com.intellij.javaee.util.AgentServerInstancePoller;
import com.intellij.javaee.util.IDeployStateChecker;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import java.io.IOException;
import org.springframework.web.client.RestClientException;

public abstract class CFCloudAgentDeploymentBase
implements CloudAgentDeployment {
    private final CFCloudAgentApplicationBase myApplication;
    private final CFCloudAgentDeploymentConfiguration myConfig;

    public CFCloudAgentDeploymentBase(CFCloudAgentApplicationBase application, CFCloudAgentDeploymentConfiguration config) {
        this.myApplication = application;
        this.myConfig = config;
    }

    protected CFCloudAgentBase getAgent() {
        return this.myApplication.getAgent();
    }

    protected final CFCloudAgentDeploymentConfiguration getConfig() {
        return this.myConfig;
    }

    protected final String getDeploymentName() {
        return this.myConfig.getDeploymentName();
    }

    private AgentServerInstancePoller getPoller() {
        return this.getAgent().getPoller();
    }

    public void deploy(final CloudAgentDeploymentCallback callback) {
        this.undeploy(new CloudAgentDeploymentCallback(){

            public void succeeded() {
            }

            public void errorOccurred(String errorMessage) {
                CFCloudAgentDeploymentBase.this.getAgent().getLogger().debug(errorMessage);
            }
        });
        try {
            this.doDeploy();
        }
        catch (RestClientException e) {
            callback.errorOccurred(e.toString());
            return;
        }
        catch (IOException e) {
            callback.errorOccurred(e.toString());
            return;
        }
        catch (IllegalArgumentException e) {
            callback.errorOccurred(e.toString());
            return;
        }
        this.getPoller().putDeployStateChecker((IDeployStateChecker)new AgentDeployStateChecker(){
            final String deploymentName;
            {
                this.deploymentName = CFCloudAgentDeploymentBase.this.getDeploymentName();
            }

            public String getDeploymentModel() {
                return this.deploymentName;
            }

            public boolean check() {
                try {
                    boolean result = CFCloudAgentDeploymentBase.this.isRunning();
                    if (result) {
                        callback.succeeded();
                    }
                    return result;
                }
                catch (RestClientException e) {
                    callback.errorOccurred(e.toString());
                    return true;
                }
                catch (AgentDeploymentException e) {
                    callback.errorOccurred(e.getMessage());
                    return true;
                }
            }
        });
    }

    protected boolean isRunning() throws AgentDeploymentException {
        for (CFApplication application : this.getAgent().doGetApplications()) {
            if (!application.getName().equals(this.getDeploymentName())) continue;
            return application.isStateRunning() && application.getRunningInstances() > 0;
        }
        return false;
    }

    public void undeploy(CloudAgentDeploymentCallback callback) {
        this.myApplication.undeploy(callback);
    }

    protected abstract void doDeploy() throws IOException;
}

