/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.base.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.util.AgentServerInstancePoller;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import org.springframework.web.client.RestClientException;

public abstract class CFCloudAgentApplicationBase
implements CloudAgentApplication {
    private final CFCloudAgentBase myAgent;
    private final String myApplicationName;

    public CFCloudAgentApplicationBase(CFCloudAgentBase agent, String applicationName) {
        this.myAgent = agent;
        this.myApplicationName = applicationName;
    }

    public CFCloudAgentBase getAgent() {
        return this.myAgent;
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    private AgentServerInstancePoller getPoller() {
        return this.myAgent.getPoller();
    }

    public void undeploy(CloudAgentDeploymentCallback callback) {
        this.getPoller().removeDeployStateChecker((Object)this.getApplicationName());
        try {
            this.doUndeploy();
            callback.succeeded();
        }
        catch (RestClientException e) {
            callback.errorOccurred(e.toString());
        }
    }

    protected abstract void doUndeploy();
}

