/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.reactor.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.frameworks.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

public abstract class ReactorUnusedCallResultInspectionBase
extends ReactorUastInspectionBase {
    protected abstract Map<String, String> getProblemDescriptionsByReturnType();

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ReactorUnusedCallResultInspectionBase.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                UCallExpression callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element);
                if (callExpression == null) {
                    return;
                }
                PsiElement methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
                if (methodIdentifierPsi == null) {
                    return;
                }
                String problemDescription = ReactorUnusedCallResultInspectionBase.this.getTargetProblemDescription(callExpression);
                if (problemDescription != null) {
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(methodIdentifierPsi, problemDescription, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    holder.registerProblem(problemDescriptor);
                }
            }
        };
        if (psiElementVisitor == null) {
            ReactorUnusedCallResultInspectionBase.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    @Nullable
    private String getTargetProblemDescription(UCallExpression expression) {
        String returnTypeFqnName = AnalysisUastUtil.getExpressionReturnTypePsiClassFqn((UCallExpression)expression);
        if (returnTypeFqnName != null) {
            return AnalysisUastUtil.isExpressionResultValueUsed((UCallExpression)expression) ? null : this.getProblemDescriptionsByReturnType().get(returnTypeFqnName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/frameworks/reactor/inspections/ReactorUnusedCallResultInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/frameworks/reactor/inspections/ReactorUnusedCallResultInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

