/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.reactor.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.frameworks.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

public abstract class ReactorInterfaceImplementationInspectionBase
extends ReactorUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            ReactorInterfaceImplementationInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ReactorInterfaceImplementationInspectionBase.$$$reportNull$$$0(1);
        }
        if (!this.isClassImplementingTargetInterface(aClass)) {
            return null;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor(ReactorInterfaceImplementationInspectionBase.getProblemElement(aClass), this.getProblemDescription(), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private boolean isClassImplementingTargetInterface(@NotNull UClass aClass) {
        if (aClass == null) {
            ReactorInterfaceImplementationInspectionBase.$$$reportNull$$$0(2);
        }
        return aClass.getUastSuperTypes().stream().anyMatch(e -> this.getInterfaceQualifiedName().equals(e.getQualifiedName()));
    }

    @NotNull
    private static PsiElement getProblemElement(UClass aClass) {
        UElement anchor = aClass.getUastAnchor();
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)anchor);
        if (identifier != null) {
            PsiElement psiElement = identifier;
            if (psiElement == null) {
                ReactorInterfaceImplementationInspectionBase.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiClass psiClass = aClass.getPsi();
        if (psiClass == null) {
            ReactorInterfaceImplementationInspectionBase.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    @NotNull
    protected abstract String getInterfaceQualifiedName();

    @NotNull
    protected abstract String getProblemDescription();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/frameworks/reactor/inspections/ReactorInterfaceImplementationInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/frameworks/reactor/inspections/ReactorInterfaceImplementationInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isClassImplementingTargetInterface";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

