/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.openapi.diagnostic.Logger;
import org.intellij.j2ee.web.resin.ResinPersistentData;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.configuration.JmxConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigurationStrategy;
import org.jetbrains.annotations.Nullable;

public class ResinPersistentDataHelper {
    private static final Logger LOG = Logger.getInstance(ResinPersistentDataHelper.class);
    private final ApplicationServer myApplicationServer;

    public ResinPersistentDataHelper(ApplicationServer applicationServer) {
        this.myApplicationServer = applicationServer;
    }

    @Nullable
    public ResinPersistentData getPersistentData() {
        return this.myApplicationServer != null ? (ResinPersistentData)this.myApplicationServer.getPersistentData() : null;
    }

    @Nullable
    public ResinInstallation getInstallation() {
        try {
            return this.getInstallationOrError();
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @Nullable
    public ResinInstallation getInstallationOrError() throws ExecutionException {
        ResinPersistentData persistentData = this.getPersistentData();
        return persistentData != null ? ResinInstallation.create(persistentData.RESIN_HOME) : null;
    }

    @Nullable
    ResinConfigurationStrategy getStrategy() {
        ResinInstallation installation = this.getInstallation();
        return installation == null ? null : ResinConfigurationStrategy.getForInstallation(installation);
    }

    @Nullable
    public JmxConfigurationStrategy getJmxStrategy() {
        ResinConfigurationStrategy strategy = this.getStrategy();
        return strategy instanceof JmxConfigurationStrategy ? (JmxConfigurationStrategy)((Object)strategy) : null;
    }

    public boolean hasJmxStrategy() {
        return this.getJmxStrategy() != null;
    }
}

