/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.view.tool.ArtifactSyncTrackerListener;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactSyncTracker
implements BaseComponent {
    private final Project myProject;
    private ArtifactSyncTrackerListener myListener;
    private Map<CommonModel, ServerSync> myServerToSync;

    public ArtifactSyncTracker(@NotNull Project project) {
        if (project == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                if (compileContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!aborted && errors == 0) {
                    ArtifactSyncTracker.this.onCompilationSuccess(compileContext);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/javaee/view/tool/ArtifactSyncTracker$1", "compilationFinished"));
            }
        });
    }

    public Map<CommonModel, ServerSync> getServerToSync(boolean forceUpdate) {
        Map<CommonModel, ServerSync> oldServerToSync = this.myServerToSync;
        if (oldServerToSync != null && !forceUpdate) {
            return oldServerToSync;
        }
        THashMap result = new THashMap();
        new ServersIterator((Map)result, oldServerToSync){
            final /* synthetic */ Map val$result;
            final /* synthetic */ Map val$oldServerToSync;
            {
                this.val$result = map;
                this.val$oldServerToSync = map2;
            }

            @Override
            protected void processServer(CommonModel server) {
                this.val$result.put(server, this.val$oldServerToSync != null && this.val$oldServerToSync.containsKey(server) ? (ServerSync)this.val$oldServerToSync.get(server) : new ServerSync());
            }
        }.iterateServers();
        this.myServerToSync = result;
        return result;
    }

    public void setListener(ArtifactSyncTrackerListener listener) {
        this.myListener = listener;
    }

    private void onCompilationSuccess(CompileContext compileContext) {
        Artifact[] compiledArtifacts = ArtifactCompileScope.getArtifacts((CompileScope)compileContext.getCompileScope());
        if (compiledArtifacts == null) {
            return;
        }
        final List<Artifact> compiledArtifactsList = Arrays.asList(compiledArtifacts);
        new ServersIterator(){

            @Override
            protected void processServer(CommonModel server) {
                ArtifactSyncTracker.this.findOrCreateServerSync(server).markArtifactsUnsynced(compiledArtifactsList);
            }
        }.iterateServers();
        if (this.myListener != null) {
            this.myListener.artifactsUnsynced();
        }
    }

    public void updateServersList() {
        this.getServerToSync(true);
    }

    public boolean isArtifactSynced(CommonStrategy server, Artifact artifact) {
        return this.findOrCreateServerSync((CommonModel)server).isArtifactSynced(artifact);
    }

    public void updateDeploymentSync(CommonStrategy server, DeploymentModel model, DeploymentStatus newStatus) {
        Artifact artifact = model.getArtifact();
        if (artifact != null) {
            this.updateArtifactSync(server, artifact, newStatus);
        }
    }

    private void updateArtifactSync(CommonStrategy server, Artifact artifact, DeploymentStatus newStatus) {
        if (newStatus == DeploymentStatus.DEPLOYED) {
            this.findOrCreateServerSync((CommonModel)server).markArtifactSynced(artifact);
        }
    }

    @NotNull
    private ServerSync findOrCreateServerSync(@NotNull CommonModel server) {
        Map<CommonModel, ServerSync> serverToSync;
        if (server == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(1);
        }
        if ((serverToSync = this.getServerToSync(false)).containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                ArtifactSyncTracker.$$$reportNull$$$0(2);
            }
            return serverSync;
        }
        serverToSync = this.getServerToSync(true);
        if (serverToSync.containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                ArtifactSyncTracker.$$$reportNull$$$0(3);
            }
            return serverSync;
        }
        ServerSync result = new ServerSync();
        serverToSync.put(server, result);
        ServerSync serverSync = result;
        if (serverSync == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(4);
        }
        return serverSync;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/view/tool/ArtifactSyncTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/view/tool/ArtifactSyncTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateServerSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateServerSync";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class ServersIterator {
        private ServersIterator() {
        }

        public void iterateServers() {
            for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)ArtifactSyncTracker.this.myProject).getAllSettings()) {
                if (!(configuration.getConfiguration() instanceof CommonModel)) continue;
                this.processServer((CommonModel)configuration.getConfiguration());
            }
        }

        protected abstract void processServer(CommonModel var1);
    }

    private static class ServerSync {
        private final Set<Artifact> mySyncedArtifacts = new HashSet<Artifact>();

        ServerSync() {
        }

        public void markArtifactsUnsynced(Collection<Artifact> unsyncedArtifacts) {
            this.mySyncedArtifacts.removeAll(unsyncedArtifacts);
        }

        public void markArtifactSynced(Artifact syncedArtifact) {
            this.mySyncedArtifacts.add(syncedArtifact);
        }

        public boolean isArtifactSynced(Artifact artifact) {
            return this.mySyncedArtifacts.contains(artifact);
        }
    }
}

