/*
 * Decompiled with CFR 0.152.
 */
package io.socket;

class IOMessage {
    public static final int TYPE_DISCONNECT = 0;
    public static final int TYPE_CONNECT = 1;
    public static final int TYPE_HEARTBEAT = 2;
    public static final int TYPE_MESSAGE = 3;
    public static final int TYPE_JSON_MESSAGE = 4;
    public static final int TYPE_EVENT = 5;
    public static final int TYPE_ACK = 6;
    public static final int TYPE_ERROR = 7;
    public static final int TYPE_NOOP = 8;
    public static final int FIELD_TYPE = 0;
    public static final int FIELD_ID = 1;
    public static final int FIELD_ENDPOINT = 2;
    public static final int FIELD_DATA = 3;
    public static final int NUM_FIELDS = 4;
    private final String[] fields = new String[4];
    private int type;

    public IOMessage(int type, String id, String namespace, String data) {
        this.type = type;
        this.fields[1] = id;
        this.fields[0] = "" + type;
        this.fields[2] = namespace;
        this.fields[3] = data;
    }

    public IOMessage(int type, String namespace, String data) {
        this(type, null, namespace, data);
    }

    public IOMessage(String message) {
        String[] fields = message.split(":", 4);
        for (int i = 0; i < fields.length; ++i) {
            this.fields[i] = fields[i];
            if (i != 0) continue;
            this.type = Integer.parseInt(fields[i]);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.fields.length; ++i) {
            builder.append(':');
            if (this.fields[i] == null) continue;
            builder.append(this.fields[i]);
        }
        return builder.substring(1);
    }

    public int getType() {
        return this.type;
    }

    public String getId() {
        return this.fields[1];
    }

    public void setId(String id) {
        this.fields[1] = id;
    }

    public String getEndpoint() {
        return this.fields[2];
    }

    public String getData() {
        return this.fields[3];
    }
}

