/*
 * Decompiled with CFR 0.152.
 */
package io.socket;

import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.IOMessage;
import io.socket.IOTransport;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import io.socket.WebsocketTransport;
import io.socket.XhrTransport;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class IOConnection
implements IOCallback {
    static final Logger logger = Logger.getLogger("io.socket");
    public static final String FRAME_DELIMITER = "\ufffd";
    private static final int STATE_INIT = 0;
    private static final int STATE_HANDSHAKE = 1;
    private static final int STATE_CONNECTING = 2;
    private static final int STATE_READY = 3;
    private static final int STATE_INTERRUPTED = 4;
    private static final int STATE_INVALID = 6;
    private int state = 0;
    public static final String SOCKET_IO_1 = "/socket.io/1/";
    private static SSLContext sslContext = null;
    private static HashMap<String, List<IOConnection>> connections = new HashMap();
    private URL url;
    private IOTransport transport;
    private int connectTimeout = 10000;
    private String sessionId;
    private long heartbeatTimeout;
    private long closingTimeout;
    private List<String> protocols;
    private ConcurrentLinkedQueue<String> outputBuffer = new ConcurrentLinkedQueue();
    private HashMap<String, SocketIO> sockets = new HashMap();
    private Properties headers;
    private SocketIO firstSocket = null;
    private final Timer backgroundTimer = new Timer("backgroundTimer");
    private String urlStr;
    private Exception lastException;
    private int nextId = 1;
    HashMap<Integer, IOAcknowledge> acknowledge = new HashMap();
    private boolean keepAliveInQueue;
    private HearbeatTimeoutTask heartbeatTimeoutTask;
    private ReconnectTask reconnectTask = null;

    public static void setSslContext(SSLContext sslContext) {
        IOConnection.sslContext = sslContext;
    }

    public static SSLContext getSslContext() {
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOConnection register(String origin, SocketIO socket) {
        List<IOConnection> list = connections.get(origin);
        if (list == null) {
            list = new LinkedList<IOConnection>();
            connections.put(origin, list);
        } else {
            List<IOConnection> list2 = list;
            synchronized (list2) {
                for (IOConnection connection : list) {
                    if (!connection.register(socket)) continue;
                    return connection;
                }
            }
        }
        IOConnection connection = new IOConnection(origin, socket);
        list.add(connection);
        return connection;
    }

    public synchronized boolean register(SocketIO socket) {
        String namespace = socket.getNamespace();
        if (this.sockets.containsKey(namespace)) {
            return false;
        }
        this.sockets.put(namespace, socket);
        socket.setHeaders(this.headers);
        IOMessage connect = new IOMessage(1, socket.getNamespace(), "");
        this.sendPlain(connect.toString());
        return true;
    }

    public synchronized void unregister(SocketIO socket) {
        this.sendPlain("0::" + socket.getNamespace());
        this.sockets.remove(socket.getNamespace());
        socket.getCallback().onDisconnect();
        if (this.sockets.size() == 0) {
            this.cleanup();
        }
    }

    private void handshake() {
        try {
            this.setState(1);
            URL url = new URL(this.url.toString() + SOCKET_IO_1);
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.connectTimeout);
            for (Map.Entry<Object, Object> entry : this.headers.entrySet()) {
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            InputStream stream = connection.getInputStream();
            Scanner in = new Scanner(stream);
            String response = in.nextLine();
            String[] data = response.split(":");
            this.sessionId = data[0];
            this.heartbeatTimeout = Long.parseLong(data[1]) * 1000L;
            this.closingTimeout = Long.parseLong(data[2]) * 1000L;
            this.protocols = Arrays.asList(data[3].split(","));
        }
        catch (Exception e) {
            this.error(new SocketIOException("Error while handshaking", e));
        }
    }

    private synchronized void connectTransport() {
        if (this.getState() == 6) {
            return;
        }
        this.setState(2);
        if (this.protocols.contains("websocket")) {
            this.transport = WebsocketTransport.create(this.url, this);
        } else if (this.protocols.contains("xhr-polling")) {
            this.transport = XhrTransport.create(this.url, this);
        } else {
            this.error(new SocketIOException("Server supports no available transports. You should reconfigure the server to support a available transport"));
            return;
        }
        this.transport.connect();
    }

    private IOAcknowledge remoteAcknowledge(IOMessage message) {
        String _id = message.getId();
        if (_id.equals("")) {
            return null;
        }
        if (!_id.endsWith("+")) {
            _id = _id + "+";
        }
        final String id = _id;
        final String endPoint = message.getEndpoint();
        return new IOAcknowledge(){

            @Override
            public void ack(Object ... args) {
                JSONArray array = new JSONArray();
                for (Object o : args) {
                    try {
                        array.put(o == null ? JSONObject.NULL : o);
                    }
                    catch (Exception e) {
                        IOConnection.this.error(new SocketIOException("You can only put values in IOAcknowledge.ack() which can be handled by JSONArray.put()", e));
                    }
                }
                IOMessage ackMsg = new IOMessage(6, endPoint, id + array.toString());
                IOConnection.this.sendPlain(ackMsg.toString());
            }
        };
    }

    private void synthesizeAck(IOMessage message, IOAcknowledge ack) {
        if (ack != null) {
            int id = this.nextId++;
            this.acknowledge.put(id, ack);
            message.setId(id + "+");
        }
    }

    private IOConnection(String url, SocketIO socket) {
        try {
            this.url = new URL(url);
            this.urlStr = url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.firstSocket = socket;
        this.headers = socket.getHeaders();
        this.sockets.put(socket.getNamespace(), socket);
        new ConnectThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() {
        this.setState(6);
        if (this.transport != null) {
            this.transport.disconnect();
        }
        this.sockets.clear();
        HashMap<String, List<IOConnection>> hashMap = connections;
        synchronized (hashMap) {
            List<IOConnection> con = connections.get(this.urlStr);
            if (con != null && con.size() > 1) {
                con.remove(this);
            } else {
                connections.remove(this.urlStr);
            }
        }
        logger.info("Cleanup");
        this.backgroundTimer.cancel();
    }

    private void error(SocketIOException e) {
        for (SocketIO socket : this.sockets.values()) {
            socket.getCallback().onError(e);
        }
        this.cleanup();
    }

    private synchronized void sendPlain(String text) {
        if (this.getState() == 3) {
            try {
                logger.info("> " + text);
                this.transport.send(text);
            }
            catch (Exception e) {
                logger.info("IOEx: saving");
                this.outputBuffer.add(text);
            }
        } else {
            this.outputBuffer.add(text);
        }
    }

    private void invalidateTransport() {
        if (this.transport != null) {
            this.transport.invalidate();
        }
        this.transport = null;
    }

    private synchronized void resetTimeout() {
        if (this.heartbeatTimeoutTask != null) {
            this.heartbeatTimeoutTask.cancel();
        }
        if (this.getState() != 6) {
            this.heartbeatTimeoutTask = new HearbeatTimeoutTask();
            this.backgroundTimer.schedule((TimerTask)this.heartbeatTimeoutTask, this.closingTimeout + this.heartbeatTimeout);
        }
    }

    private IOCallback findCallback(IOMessage message) throws SocketIOException {
        if ("".equals(message.getEndpoint())) {
            return this;
        }
        SocketIO socket = this.sockets.get(message.getEndpoint());
        if (socket == null) {
            throw new SocketIOException("Cannot find socket for '" + message.getEndpoint() + "'");
        }
        return socket.getCallback();
    }

    public synchronized void transportConnected() {
        this.setState(3);
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
        this.resetTimeout();
        if (this.transport.canSendBulk()) {
            ConcurrentLinkedQueue<String> outputBuffer = this.outputBuffer;
            this.outputBuffer = new ConcurrentLinkedQueue();
            try {
                String[] texts = outputBuffer.toArray(new String[outputBuffer.size()]);
                logger.info("Bulk start:");
                for (String text : texts) {
                    logger.info("> " + text);
                }
                logger.info("Bulk end");
                this.transport.sendBulk(texts);
            }
            catch (IOException e) {
                this.outputBuffer = outputBuffer;
            }
        } else {
            String text;
            while ((text = this.outputBuffer.poll()) != null) {
                this.sendPlain(text);
            }
        }
        this.keepAliveInQueue = false;
    }

    public void transportDisconnected() {
        this.lastException = null;
        this.setState(4);
        this.reconnect();
    }

    public void transportError(Exception error) {
        this.lastException = error;
        this.setState(4);
        this.reconnect();
    }

    public void transportData(String text) {
        if (!text.startsWith(FRAME_DELIMITER)) {
            this.transportMessage(text);
            return;
        }
        ListIterator<String> fragments = Arrays.asList(text.split(FRAME_DELIMITER)).listIterator(1);
        while (fragments.hasNext()) {
            String string;
            int length = Integer.parseInt((String)fragments.next());
            if (length != (string = (String)fragments.next()).length()) {
                this.error(new SocketIOException("Garbage from server: " + text));
                return;
            }
            this.transportMessage(string);
        }
    }

    public void transportMessage(String text) {
        IOMessage message;
        logger.info("< " + text);
        try {
            message = new IOMessage(text);
        }
        catch (Exception e) {
            this.error(new SocketIOException("Garbage from server: " + text, e));
            return;
        }
        this.resetTimeout();
        switch (message.getType()) {
            case 0: {
                try {
                    this.findCallback(message).onDisconnect();
                }
                catch (Exception e) {
                    this.error(new SocketIOException("Exception was thrown in onDisconnect()", e));
                }
                break;
            }
            case 1: {
                try {
                    if (this.firstSocket != null && "".equals(message.getEndpoint())) {
                        if (this.firstSocket.getNamespace().equals("")) {
                            this.firstSocket.getCallback().onConnect();
                        } else {
                            IOMessage connect = new IOMessage(1, this.firstSocket.getNamespace(), "");
                            this.sendPlain(connect.toString());
                        }
                    } else {
                        this.findCallback(message).onConnect();
                    }
                    this.firstSocket = null;
                }
                catch (Exception e) {
                    this.error(new SocketIOException("Exception was thrown in onConnect()", e));
                }
                break;
            }
            case 2: {
                this.sendPlain("2::");
                break;
            }
            case 3: {
                try {
                    this.findCallback(message).onMessage(message.getData(), this.remoteAcknowledge(message));
                }
                catch (Exception e) {
                    this.error(new SocketIOException("Exception was thrown in onMessage(String).\nMessage was: " + message.toString(), e));
                }
                break;
            }
            case 4: {
                try {
                    JSONObject obj = null;
                    String data = message.getData();
                    if (!data.trim().equals("null")) {
                        obj = new JSONObject(data);
                    }
                    try {
                        this.findCallback(message).onMessage(obj, this.remoteAcknowledge(message));
                    }
                    catch (Exception e) {
                        this.error(new SocketIOException("Exception was thrown in onMessage(JSONObject).\nMessage was: " + message.toString(), e));
                    }
                }
                catch (JSONException e) {
                    logger.warning("Malformated JSON received");
                }
                break;
            }
            case 5: {
                try {
                    Object[] argsArray;
                    JSONObject event = new JSONObject(message.getData());
                    if (event.has("args")) {
                        JSONArray args = event.getJSONArray("args");
                        argsArray = new Object[args.length()];
                        for (int i = 0; i < args.length(); ++i) {
                            if (args.isNull(i)) continue;
                            argsArray[i] = args.get(i);
                        }
                    } else {
                        argsArray = new Object[]{};
                    }
                    String eventName = event.getString("name");
                    try {
                        this.findCallback(message).on(eventName, this.remoteAcknowledge(message), argsArray);
                    }
                    catch (Exception e) {
                        this.error(new SocketIOException("Exception was thrown in on(String, JSONObject[]).\nMessage was: " + message.toString(), e));
                    }
                }
                catch (JSONException e) {
                    logger.warning("Malformated JSON received");
                }
                break;
            }
            case 6: {
                String[] data = message.getData().split("\\+", 2);
                if (data.length == 2) {
                    try {
                        int id = Integer.parseInt(data[0]);
                        IOAcknowledge ack = this.acknowledge.get(id);
                        if (ack == null) {
                            logger.warning("Received unknown ack packet");
                            break;
                        }
                        JSONArray array = new JSONArray(data[1]);
                        Object[] args = new Object[array.length()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = array.get(i);
                        }
                        ack.ack(args);
                        this.acknowledge.remove(id);
                    }
                    catch (NumberFormatException e) {
                        logger.warning("Received malformated Acknowledge! This is potentially filling up the acknowledges!");
                    }
                    catch (JSONException e) {
                        logger.warning("Received malformated Acknowledge data!");
                    }
                    break;
                }
                if (data.length != 1) break;
                this.sendPlain("6:::" + data[0]);
                break;
            }
            case 7: {
                try {
                    this.findCallback(message).onError(new SocketIOException(message.getData()));
                }
                catch (SocketIOException e) {
                    this.error(e);
                }
                if (!message.getData().endsWith("+0")) break;
                this.cleanup();
                break;
            }
            case 8: {
                break;
            }
            default: {
                logger.warning("Unkown type received" + message.getType());
            }
        }
    }

    public synchronized void reconnect() {
        if (this.getState() != 6) {
            this.invalidateTransport();
            this.setState(4);
            if (this.reconnectTask != null) {
                this.reconnectTask.cancel();
            }
            this.reconnectTask = new ReconnectTask();
            this.backgroundTimer.schedule((TimerTask)this.reconnectTask, 1000L);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void send(SocketIO socket, IOAcknowledge ack, String text) {
        IOMessage message = new IOMessage(3, socket.getNamespace(), text);
        this.synthesizeAck(message, ack);
        this.sendPlain(message.toString());
    }

    public void send(SocketIO socket, IOAcknowledge ack, JSONObject json) {
        IOMessage message = new IOMessage(4, socket.getNamespace(), json.toString());
        this.synthesizeAck(message, ack);
        this.sendPlain(message.toString());
    }

    public void emit(SocketIO socket, String event, IOAcknowledge ack, Object ... args) {
        try {
            JSONObject json = new JSONObject().put("name", event).put("args", new JSONArray(Arrays.asList(args)));
            IOMessage message = new IOMessage(5, socket.getNamespace(), json.toString());
            this.synthesizeAck(message, ack);
            this.sendPlain(message.toString());
        }
        catch (JSONException e) {
            this.error(new SocketIOException("Error while emitting an event. Make sure you only try to send arguments, which can be serialized into JSON."));
        }
    }

    public boolean isConnected() {
        return this.getState() == 3;
    }

    private synchronized int getState() {
        return this.state;
    }

    private synchronized void setState(int state) {
        if (this.getState() != 6) {
            this.state = state;
        }
    }

    public IOTransport getTransport() {
        return this.transport;
    }

    @Override
    public void onDisconnect() {
        SocketIO socket = this.sockets.get("");
        if (socket != null) {
            socket.getCallback().onDisconnect();
        }
    }

    @Override
    public void onConnect() {
        SocketIO socket = this.sockets.get("");
        if (socket != null) {
            socket.getCallback().onConnect();
        }
    }

    @Override
    public void onMessage(String data, IOAcknowledge ack) {
        for (SocketIO socket : this.sockets.values()) {
            socket.getCallback().onMessage(data, ack);
        }
    }

    @Override
    public void onMessage(JSONObject json, IOAcknowledge ack) {
        for (SocketIO socket : this.sockets.values()) {
            socket.getCallback().onMessage(json, ack);
        }
    }

    @Override
    public void on(String event, IOAcknowledge ack, Object ... args) {
        for (SocketIO socket : this.sockets.values()) {
            socket.getCallback().on(event, ack, args);
        }
    }

    @Override
    public void onError(SocketIOException socketIOException) {
        for (SocketIO socket : this.sockets.values()) {
            socket.getCallback().onError(socketIOException);
        }
    }

    private class ConnectThread
    extends Thread {
        public ConnectThread() {
            super("ConnectThread");
        }

        @Override
        public void run() {
            if (IOConnection.this.getState() == 0) {
                IOConnection.this.handshake();
            }
            IOConnection.this.connectTransport();
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private ReconnectTask() {
        }

        @Override
        public void run() {
            IOConnection.this.connectTransport();
            if (!IOConnection.this.keepAliveInQueue) {
                IOConnection.this.sendPlain("2::");
                IOConnection.this.keepAliveInQueue = true;
            }
        }
    }

    private class HearbeatTimeoutTask
    extends TimerTask {
        private HearbeatTimeoutTask() {
        }

        @Override
        public void run() {
            IOConnection.this.error(new SocketIOException("Timeout Error. No heartbeat from server within life time of the socket. closing.", IOConnection.this.lastException));
        }
    }
}

