/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class SFormsFastMapDirect {
    private int size;
    private final FastSparseSetFactory.FastSparseSet<Integer>[][] elements = new FastSparseSetFactory.FastSparseSet[3][];
    private final int[][] next = new int[3][];

    public SFormsFastMapDirect() {
        this(true);
    }

    private SFormsFastMapDirect(boolean initialize) {
        if (initialize) {
            for (int i = 2; i >= 0; --i) {
                FastSparseSetFactory.FastSparseSet[] empty = FastSparseSetFactory.FastSparseSet.EMPTY_ARRAY;
                this.elements[i] = empty;
                this.next[i] = InterpreterUtil.EMPTY_INT_ARRAY;
            }
        }
    }

    public SFormsFastMapDirect(SFormsFastMapDirect map) {
        for (int i = 2; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer>[] arr = map.elements[i];
            int[] arrnext = map.next[i];
            int length = arr.length;
            FastSparseSetFactory.FastSparseSet[] arrnew = new FastSparseSetFactory.FastSparseSet[length];
            int[] arrnextnew = new int[length];
            System.arraycopy(arr, 0, arrnew, 0, length);
            System.arraycopy(arrnext, 0, arrnextnew, 0, length);
            this.elements[i] = arrnew;
            this.next[i] = arrnextnew;
            this.size = map.size;
        }
    }

    public SFormsFastMapDirect getCopy() {
        SFormsFastMapDirect map = new SFormsFastMapDirect(false);
        map.size = this.size;
        FastSparseSetFactory.FastSparseSet<Integer>[][] mapelements = map.elements;
        int[][] mapnext = map.next;
        for (int i = 2; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer>[] arr = this.elements[i];
            int length = arr.length;
            if (length > 0) {
                int[] arrnext = this.next[i];
                FastSparseSetFactory.FastSparseSet[] arrnew = new FastSparseSetFactory.FastSparseSet[length];
                int[] arrnextnew = new int[length];
                System.arraycopy(arrnext, 0, arrnextnew, 0, length);
                mapelements[i] = arrnew;
                mapnext[i] = arrnextnew;
                int pointer = 0;
                do {
                    FastSparseSetFactory.FastSparseSet<Integer> set;
                    if ((set = arr[pointer]) == null) continue;
                    arrnew[pointer] = set.getCopy();
                } while ((pointer = arrnext[pointer]) != 0);
                continue;
            }
            mapelements[i] = FastSparseSetFactory.FastSparseSet.EMPTY_ARRAY;
            mapnext[i] = InterpreterUtil.EMPTY_INT_ARRAY;
        }
        return map;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void put(int key, FastSparseSetFactory.FastSparseSet<Integer> value) {
        this.putInternal(key, value, false);
    }

    public void removeAllFields() {
        FastSparseSetFactory.FastSparseSet<Integer>[] arr = this.elements[2];
        int[] arrnext = this.next[2];
        for (int i = arr.length - 1; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer> val = arr[i];
            if (val != null) {
                arr[i] = null;
                --this.size;
            }
            arrnext[i] = 0;
        }
    }

    public void putInternal(int key, FastSparseSetFactory.FastSparseSet<Integer> value, boolean remove) {
        int index = 0;
        int ikey = key;
        if (ikey < 0) {
            index = 2;
            ikey = -ikey;
        } else if (ikey >= 10000) {
            index = 1;
            ikey -= 10000;
        }
        FastSparseSetFactory.FastSparseSet<Integer>[] arr = this.elements[index];
        if (ikey >= arr.length) {
            if (remove) {
                return;
            }
            arr = this.ensureCapacity(index, ikey + 1, false);
        }
        FastSparseSetFactory.FastSparseSet<Integer> oldval = arr[ikey];
        arr[ikey] = value;
        int[] arrnext = this.next[index];
        if (oldval == null && value != null) {
            ++this.size;
            SFormsFastMapDirect.changeNext(arrnext, ikey, arrnext[ikey], ikey);
        } else if (oldval != null && value == null) {
            --this.size;
            SFormsFastMapDirect.changeNext(arrnext, ikey, ikey, arrnext[ikey]);
        }
    }

    private static void changeNext(int[] arrnext, int key, int oldnext, int newnext) {
        for (int i = key - 1; i >= 0 && arrnext[i] == oldnext; --i) {
            arrnext[i] = newnext;
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public FastSparseSetFactory.FastSparseSet<Integer> get(int key) {
        int index = 0;
        if (key < 0) {
            index = 2;
            key = -key;
        } else if (key >= 10000) {
            index = 1;
            key -= 10000;
        }
        FastSparseSetFactory.FastSparseSet<Integer>[] arr = this.elements[index];
        if (key < arr.length) {
            return arr[key];
        }
        return null;
    }

    public void complement(SFormsFastMapDirect map) {
        block0: for (int i = 2; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer>[] lstOwn = this.elements[i];
            if (lstOwn.length == 0) continue;
            FastSparseSetFactory.FastSparseSet<Integer>[] lstExtern = map.elements[i];
            int[] arrnext = this.next[i];
            int pointer = 0;
            do {
                FastSparseSetFactory.FastSparseSet<Integer> first;
                if ((first = lstOwn[pointer]) == null) continue;
                if (pointer >= lstExtern.length) continue block0;
                FastSparseSetFactory.FastSparseSet<Integer> second = lstExtern[pointer];
                if (second == null) continue;
                first.complement(second);
                if (!first.isEmpty()) continue;
                lstOwn[pointer] = null;
                --this.size;
                SFormsFastMapDirect.changeNext(arrnext, pointer, pointer, arrnext[pointer]);
            } while ((pointer = arrnext[pointer]) != 0);
        }
    }

    public void intersection(SFormsFastMapDirect map) {
        for (int i = 2; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer>[] lstOwn = this.elements[i];
            if (lstOwn.length == 0) continue;
            FastSparseSetFactory.FastSparseSet<Integer>[] lstExtern = map.elements[i];
            int[] arrnext = this.next[i];
            int pointer = 0;
            do {
                FastSparseSetFactory.FastSparseSet<Integer> first;
                if ((first = lstOwn[pointer]) == null) continue;
                FastSparseSetFactory.FastSparseSet<Integer> second = null;
                if (pointer < lstExtern.length) {
                    second = lstExtern[pointer];
                }
                if (second != null) {
                    first.intersection(second);
                }
                if (second != null && !first.isEmpty()) continue;
                lstOwn[pointer] = null;
                --this.size;
                SFormsFastMapDirect.changeNext(arrnext, pointer, pointer, arrnext[pointer]);
            } while ((pointer = arrnext[pointer]) != 0);
        }
    }

    public void union(SFormsFastMapDirect map) {
        for (int i = 2; i >= 0; --i) {
            FastSparseSetFactory.FastSparseSet<Integer>[] lstExtern = map.elements[i];
            if (lstExtern.length == 0) continue;
            FastSparseSetFactory.FastSparseSet<Integer>[] lstOwn = this.elements[i];
            int[] arrnext = this.next[i];
            int[] arrnextExtern = map.next[i];
            int pointer = 0;
            do {
                FastSparseSetFactory.FastSparseSet<Integer> second;
                if (pointer >= lstOwn.length) {
                    lstOwn = this.ensureCapacity(i, lstExtern.length, true);
                    arrnext = this.next[i];
                }
                if ((second = lstExtern[pointer]) == null) continue;
                FastSparseSetFactory.FastSparseSet<Integer> first = lstOwn[pointer];
                if (first == null) {
                    lstOwn[pointer] = second.getCopy();
                    ++this.size;
                    SFormsFastMapDirect.changeNext(arrnext, pointer, arrnext[pointer], pointer);
                    continue;
                }
                first.union(second);
            } while ((pointer = arrnextExtern[pointer]) != 0);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        List<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> lst = this.entryList();
        if (lst != null) {
            boolean first = true;
            for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : lst) {
                if (!first) {
                    buffer.append(", ");
                } else {
                    first = false;
                }
                Set<Integer> set = entry.getValue().toPlainSet();
                buffer.append(entry.getKey()).append("={").append(set.toString()).append("}");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    public List<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> entryList() {
        ArrayList<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> list = new ArrayList<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>>();
        for (int i = 2; i >= 0; --i) {
            int ikey = 0;
            for (final FastSparseSetFactory.FastSparseSet<Integer> ent : this.elements[i]) {
                if (ent != null) {
                    final int key = i == 0 ? ikey : (i == 1 ? ikey + 10000 : -ikey);
                    list.add(new Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>(){
                        private final Integer var;
                        private final FastSparseSetFactory.FastSparseSet<Integer> val;
                        {
                            this.var = key;
                            this.val = ent;
                        }

                        @Override
                        public Integer getKey() {
                            return this.var;
                        }

                        @Override
                        public FastSparseSetFactory.FastSparseSet<Integer> getValue() {
                            return this.val;
                        }

                        @Override
                        public FastSparseSetFactory.FastSparseSet<Integer> setValue(FastSparseSetFactory.FastSparseSet<Integer> newvalue) {
                            return null;
                        }
                    });
                }
                ++ikey;
            }
        }
        return list;
    }

    private FastSparseSetFactory.FastSparseSet<Integer>[] ensureCapacity(int index, int size, boolean exact) {
        FastSparseSetFactory.FastSparseSet<Integer>[] arr = this.elements[index];
        int[] arrnext = this.next[index];
        int minsize = size;
        if (!exact && size > (minsize = 2 * arr.length / 3 + 1)) {
            minsize = size;
        }
        FastSparseSetFactory.FastSparseSet[] arrnew = new FastSparseSetFactory.FastSparseSet[minsize];
        System.arraycopy(arr, 0, arrnew, 0, arr.length);
        int[] arrnextnew = new int[minsize];
        System.arraycopy(arrnext, 0, arrnextnew, 0, arrnext.length);
        this.elements[index] = arrnew;
        this.next[index] = arrnextnew;
        return arrnew;
    }
}

