/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.layout;

import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.layout.MapUndoableWrapper;
import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChartVirtualLayoutCoordinator
implements ChartLayoutCoordinator {
    private final boolean persistAutoGeneratedLayout;
    @NotNull
    private final ChartLayoutCoordinator chartLayoutCoordinator;
    @NotNull
    final Map<String, ChartLayoutCoordinator.NodeLayout> nodeLayouts;
    @NotNull
    final Map<Pair<String, String>, List<ChartLayoutCoordinator.Point>> edgeLayouts;

    public ChartVirtualLayoutCoordinator(@NotNull Project project, DocumentReference[] references, boolean persistAutoGeneratedLayout, @NotNull ChartLayoutCoordinator coordinator) {
        if (project == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(0);
        }
        if (coordinator == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(1);
        }
        this.nodeLayouts = new MapUndoableWrapper<String, ChartLayoutCoordinator.NodeLayout>(UndoManager.getInstance((Project)project), references, (Map<String, ChartLayoutCoordinator.NodeLayout>)new HashMap());
        this.edgeLayouts = new MapUndoableWrapper<Pair<String, String>, List<ChartLayoutCoordinator.Point>>(UndoManager.getInstance((Project)project), references, (Map<Pair<String, String>, List<ChartLayoutCoordinator.Point>>)new HashMap());
        this.persistAutoGeneratedLayout = persistAutoGeneratedLayout;
        this.chartLayoutCoordinator = coordinator;
    }

    @Override
    @Nullable
    public ChartLayoutCoordinator.NodeLayout getNodeLayout(@NotNull String nodeId, ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.NodeLayout virtualLayout;
        if (nodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(2);
        }
        return (virtualLayout = this.nodeLayouts.get(nodeId)) != null ? virtualLayout : this.chartLayoutCoordinator.getNodeLayout(nodeId, enhancer);
    }

    @Nullable
    public Runnable getCreateNodeLayoutAction(@NotNull String nodeId, @NotNull ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer, boolean isAutoGenerated) {
        if (nodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(3);
        }
        if (layout == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(4);
        }
        if (isAutoGenerated && !this.persistAutoGeneratedLayout) {
            return () -> {
                if (nodeId == null) {
                    ChartVirtualLayoutCoordinator.$$$reportNull$$$0(13);
                }
                if (layout == null) {
                    ChartVirtualLayoutCoordinator.$$$reportNull$$$0(14);
                }
                this.nodeLayouts.put(nodeId, layout);
            };
        }
        return this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
    }

    @Override
    @Nullable
    public Runnable getChangeNodeLayoutAction(@NotNull String nodeId, @NotNull ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer) {
        ChartLayoutCoordinator.NodeLayout virtualLayout;
        if (nodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(5);
        }
        if (layout == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(6);
        }
        if ((virtualLayout = this.nodeLayouts.get(nodeId)) == null) {
            return this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
        }
        if (!virtualLayout.equals(layout)) {
            Runnable action = this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
            return () -> {
                if (nodeId == null) {
                    ChartVirtualLayoutCoordinator.$$$reportNull$$$0(12);
                }
                this.nodeLayouts.remove(nodeId);
                if (action != null) {
                    action.run();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public List<ChartLayoutCoordinator.Point> getEdgePoints(@NotNull String sourceNodeId, @NotNull String targetNodeId) {
        List<ChartLayoutCoordinator.Point> points;
        if (sourceNodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(7);
        }
        if (targetNodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(8);
        }
        return (points = this.chartLayoutCoordinator.getEdgePoints(sourceNodeId, targetNodeId)) == null ? this.edgeLayouts.get(Pair.create((Object)sourceNodeId, (Object)targetNodeId)) : points;
    }

    @Override
    @Nullable
    public Runnable getChangeEdgePointsAction(@NotNull String sourceNodeId, @NotNull String targetNodeId, @NotNull List<ChartLayoutCoordinator.Point> points) {
        if (sourceNodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(9);
        }
        if (targetNodeId == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(10);
        }
        if (points == null) {
            ChartVirtualLayoutCoordinator.$$$reportNull$$$0(11);
        }
        return this.chartLayoutCoordinator.getChangeEdgePointsAction(sourceNodeId, targetNodeId, points);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinator";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeId";
                break;
            }
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNodeId";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNodeId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeLayout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCreateNodeLayoutAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeNodeLayoutAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEdgePoints";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeEdgePointsAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getChangeNodeLayoutAction$1";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getCreateNodeLayoutAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

