/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow.nodes;

import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TemplateElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedComponentNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedTemplateNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class EmbeddedComponentsNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -3375981384098659628L;
    private final List<InjectedElement> _embeddedComponentNodes = new ArrayList<InjectedElement>();

    public EmbeddedComponentsNode(Object userObject) {
        super(userObject);
        PresentationLibraryElement element = (PresentationLibraryElement)userObject;
        if (element.getElementClass().getFile() == null) {
            return;
        }
        switch (element.getElementType()) {
            case COMPONENT: {
                this.addChildElements((Component)userObject);
                break;
            }
            case PAGE: {
                this.addChildElements((Page)userObject);
                break;
            }
            case MIXIN: {
                this.addChildElements((Mixin)userObject);
            }
        }
    }

    private void addChildElements(Component component) {
        for (TemplateElement embedded : component.getEmbeddedComponents()) {
            if (!embedded.getTemplate().equals("class")) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedComponentNodes.add(embedded.getElement());
        }
        for (IResource template : component.getTemplate()) {
            this.insert(new EmbeddedTemplateNode(template, component), 0);
            this._embeddedComponentNodes.addAll(new EmbeddedTemplateNode(template, component).getEmbeddedTemplateNodes());
        }
    }

    private void addChildElements(Page page) {
        for (TemplateElement embedded : page.getEmbeddedComponents()) {
            if (!embedded.getTemplate().equals("class")) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedComponentNodes.add(embedded.getElement());
        }
        for (IResource template : page.getTemplate()) {
            this.insert(new EmbeddedTemplateNode(template, page), 0);
            this._embeddedComponentNodes.addAll(new EmbeddedTemplateNode(template, page).getEmbeddedTemplateNodes());
        }
    }

    private void addChildElements(Mixin mixin) {
        for (TemplateElement embedded : mixin.getEmbeddedComponents()) {
            if (!embedded.getTemplate().equals("class")) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedComponentNodes.add(embedded.getElement());
        }
        for (IResource template : mixin.getTemplate()) {
            this.insert(new EmbeddedTemplateNode(template, mixin), 0);
            this._embeddedComponentNodes.addAll(new EmbeddedTemplateNode(template, mixin).getEmbeddedTemplateNodes());
        }
    }

    public List<InjectedElement> getEmbeddedComponentNodes() {
        return this._embeddedComponentNodes;
    }

    @Override
    public String toString() {
        return "Embedded Components";
    }
}

