/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow;

import com.intellij.ProjectTopics;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.tapestry.core.events.FileSystemListenerAdapter;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.toolwindow.DependenciesTab;
import com.intellij.tapestry.intellij.toolwindow.DocumentationTab;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public class TapestryToolWindow
extends FileSystemListenerAdapter {
    private JPanel _mainPanel;
    private JTabbedPane _tabbedPane;
    private final DocumentationTab _documentationTab;
    private final DependenciesTab _dependenciesTab;
    private final List<IJavaClassType> _updateOnChangeFiles;
    private Module _module;
    private Object _element;
    private final Project _project;

    public TapestryToolWindow(Project project) {
        this.$$$setupUI$$$();
        this._updateOnChangeFiles = new ArrayList<IJavaClassType>();
        this._project = project;
        this._tabbedPane.removeAll();
        this._documentationTab = new DocumentationTab(this._project);
        this._tabbedPane.addTab("Live Documentation", this._documentationTab.getMainPanel());
        this._dependenciesTab = new DependenciesTab();
        this._tabbedPane.addTab("Dependencies", this._dependenciesTab.getMainPanel());
        ModuleListener moduleListener = new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                TapestryToolWindow.this.reload();
            }

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(3);
                }
                TapestryToolWindow.this.reload();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/tapestry/intellij/toolwindow/TapestryToolWindow$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)moduleListener);
        this.reload();
    }

    @Override
    public void fileDeleted(String path) {
        if (this._element == null || this._module == null) {
            return;
        }
        this._documentationTab.showDocumentation(this._element, this._project);
        this._documentationTab.setElement(this._element);
        this._dependenciesTab.showDependencies(this._module, this._element);
    }

    @Override
    public void fileContentsChanged(IResource changedFile) {
        if (this._element == null || this._module == null) {
            return;
        }
        for (IJavaClassType classType : this._updateOnChangeFiles) {
            IResource resource = classType.getFile();
            if (resource == null || resource.getFile() == null || !resource.getFile().getAbsolutePath().endsWith(changedFile.getFile().getAbsolutePath())) continue;
            this._documentationTab.showDocumentation(this._element, this._project);
            this._documentationTab.setElement(this._element);
            this._dependenciesTab.showDependencies(this._module, this._element);
        }
    }

    public void update(Module module, Object element, List<IJavaClassType> updateOnChangeFiles) {
        this._module = module;
        this._element = element;
        this._documentationTab.showDocumentation(element, this._project);
        this._documentationTab.setElement(this._element);
        this._dependenciesTab.showDependencies(module, element);
        if (element != null) {
            this._updateOnChangeFiles.clear();
            this._updateOnChangeFiles.addAll(updateOnChangeFiles);
        }
    }

    public JPanel getMainPanel() {
        return this._mainPanel;
    }

    public DocumentationTab getDocumentationTab() {
        return this._documentationTab;
    }

    public DependenciesTab getDependenciesTab() {
        return this._dependenciesTab;
    }

    private void reload() {
        for (Module module : ModuleManager.getInstance((Project)this._project).getModules()) {
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().removeFileSystemListener(this);
            TapestryModuleSupportLoader.getTapestryProject(module).getEventsManager().addFileSystemListener(this);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this._mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this._tabbedPane = jBTabbedPane;
        jBTabbedPane.setTabPlacement(3);
        jPanel.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Untitled", null, jPanel2, null);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._mainPanel;
    }
}

