/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.maven.MavenConfiguration;
import com.intellij.tapestry.core.maven.MavenUtils;
import com.intellij.tapestry.core.maven.RemoteRepositoryDescription;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AddTapestrySupportUtil {
    private static final Logger _logger = Logger.getInstance(AddTapestrySupportUtil.class);

    public static void addSupportInWriteCommandAction(@NotNull Module module, @NotNull TapestryFacetConfiguration configuration, boolean generateStartupApplication, boolean generatePom) {
        if (module == null) {
            AddTapestrySupportUtil.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            AddTapestrySupportUtil.$$$reportNull$$$0(1);
        }
        if (configuration.getApplicationPackage() == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> {
            if (module == null) {
                AddTapestrySupportUtil.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                AddTapestrySupportUtil.$$$reportNull$$$0(3);
            }
            try {
                AddTapestrySupportUtil.addSupport(module, configuration, generateStartupApplication, generatePom);
            }
            catch (Exception ex) {
                _logger.error((Throwable)ex);
            }
        });
    }

    private static void addSupport(Module module, TapestryFacetConfiguration configuration, boolean generateStartupApplication, boolean generatePom) throws Exception {
        if (generatePom) {
            AddTapestrySupportUtil.generatePom(module, configuration);
        }
    }

    private static void generatePom(Module module, TapestryFacetConfiguration configuration) throws IOException {
        ModuleRootManager rootModel = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] contentRoots = rootModel.getContentRoots();
        if (contentRoots.length == 0) {
            _logger.warn("Couldn't generate pom because it wasn't possible to determine the module content root.");
            return;
        }
        if (rootModel.getSourceRoots().length == 0) {
            _logger.warn("Coulnd't generate startup application because it wasn't possible to determine module source root");
            return;
        }
        String modulePath = contentRoots[0].getPath();
        try {
            String pomText = FileUtil.loadTextAndClose((InputStream)AddTapestrySupportUtil.class.getResourceAsStream("/fileTemplates/j2ee/Tapestry Project Pom.xml.ft"));
            pomText = pomText.replace("${GROUP}", configuration.getApplicationPackage());
            pomText = pomText.replace("${ARTIFACT}", configuration.getFilterName());
            pomText = pomText.replace("${NAME}", rootModel.getModule().getName());
            pomText = pomText.replace("${SOURCE_PATH}", rootModel.getSourceRoots()[0].getPath().substring(modulePath.length() + 1));
            pomText = pomText.replace("${TAPESTRY_VERSION}", configuration.getVersion().toString());
            VirtualFileManager.getInstance().findFileByUrl("file://" + modulePath);
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)rootModel.getModule().getProject()).findDirectory(VirtualFileManager.getInstance().findFileByUrl("file://" + modulePath));
            String pomXml = "pom.xml";
            PsiFile pomFile = psiDirectory.findFile("pom.xml");
            if (pomFile == null) {
                pomFile = psiDirectory.createFile("pom.xml");
            }
            VfsUtil.saveText((VirtualFile)pomFile.getVirtualFile(), (String)pomText);
        }
        catch (Exception ex) {
            _logger.error((Throwable)ex);
        }
        MavenUtils.createMavenSupport(modulePath, new MavenConfiguration(false, false, null, null, null, configuration.getApplicationPackage(), configuration.getFilterName(), "1.0-SNAPSHOT", new ArrayList<RemoteRepositoryDescription>()), configuration.getVersion().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tapestry/intellij/facet/AddTapestrySupportUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSupportInWriteCommandAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addSupportInWriteCommandAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

