/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaAnnotation;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IntellijJavaField
implements IJavaField {
    private final Module _module;
    private final PsiField _psiField;

    public IntellijJavaField(Module module, PsiField psiField) {
        this._module = module;
        this._psiField = psiField;
    }

    @Override
    public String getName() {
        return this._psiField.getName();
    }

    @Override
    @Nullable
    public IJavaType getType() {
        if (this._psiField.getType() instanceof PsiClassType) {
            return IdeaUtils.createJavaTypeFromPsiType(this._module, this._psiField.getType());
        }
        if (this._psiField.getType() instanceof PsiPrimitiveType) {
            return IdeaUtils.createJavaTypeFromPsiType(this._module, this._psiField.getType());
        }
        if (this._psiField.getType() instanceof PsiArrayType) {
            return IdeaUtils.createJavaTypeFromPsiType(this._module, this._psiField.getType());
        }
        return null;
    }

    @Override
    public boolean isPrivate() {
        return this._psiField.getModifierList().hasModifierProperty("private");
    }

    @Override
    public Map<String, IJavaAnnotation> getAnnotations() {
        HashMap<String, IJavaAnnotation> annotations = new HashMap<String, IJavaAnnotation>();
        for (PsiAnnotation annotation : this._psiField.getModifierList().getAnnotations()) {
            if (!annotation.isValid()) continue;
            annotations.put(annotation.getQualifiedName(), new IntellijJavaAnnotation(annotation));
        }
        return annotations;
    }

    @Override
    public String getDocumentation() {
        StringBuilder description = new StringBuilder();
        PsiDocComment document = this._psiField.getDocComment();
        if (document == null) {
            document = ((PsiField)this._psiField.getNavigationElement()).getDocComment();
        }
        if (document != null) {
            for (PsiElement comment : document.getDescriptionElements()) {
                if (comment instanceof PsiWhiteSpace) continue;
                description.append(comment.getText());
            }
        }
        return description.toString();
    }

    @Override
    public String getStringRepresentation() {
        return this._psiField.getText();
    }

    @Override
    public boolean isValid() {
        return this._psiField.isValid();
    }

    public PsiField getPsiField() {
        return this._psiField;
    }

    public boolean equals(Object obj) {
        return obj instanceof IntellijJavaField && this.getName().equals(((IntellijJavaField)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

