/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClassUtils {
    public static boolean instanceOf(Object[] items, @NotNull Class aClass) {
        if (aClass == null) {
            ClassUtils.$$$reportNull$$$0(0);
        }
        for (Object item : items) {
            if (aClass.isInstance(item)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> getClassProperties(IJavaClassType javaClassType) {
        if (javaClassType == null) {
            return new HashMap<String, Object>();
        }
        Collection<IJavaMethod> allPublicMethods = javaClassType.getPublicMethods(true);
        HashMap<String, Object> getterMethods = new HashMap<String, Object>();
        for (IJavaMethod method : allPublicMethods) {
            String nameProperty = method.getName();
            if (method.getReturnType() == null || !nameProperty.startsWith("get") && (!nameProperty.startsWith("is") || !method.getReturnType().getName().equals("boolean")) || !StringUtil.isNotEmpty((String)(nameProperty = nameProperty.startsWith("get") ? nameProperty.replaceFirst("get", "") : nameProperty.replaceFirst("is", "")))) continue;
            nameProperty = StringUtil.decapitalize((String)nameProperty);
            getterMethods.put(nameProperty, method);
        }
        Map<String, IJavaField> allFields = javaClassType.getFields(true);
        HashMap<String, IJavaField> propertyFields = new HashMap<String, IJavaField>();
        for (Map.Entry<String, IJavaField> field : allFields.entrySet()) {
            IJavaAnnotation annotation;
            if (!field.getValue().getAnnotations().containsKey("org.apache.tapestry5.annotations.Property") || (annotation = field.getValue().getAnnotations().get("org.apache.tapestry5.annotations.Property")).getParameters().containsKey("read") && annotation.getParameters().get("read")[0].equals("false")) continue;
            propertyFields.put(ClassUtils.getName(field.getKey()), field.getValue());
        }
        getterMethods.putAll(propertyFields);
        return getterMethods;
    }

    public static String getName(String name) {
        if (name.startsWith("$") || name.startsWith("_")) {
            return name.substring(1);
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/tapestry/core/util/ClassUtils", "instanceOf"));
    }
}

