/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.core.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassLocator {
    private final String[] _packageNames;
    private final ClassLoader _classLoader;
    private String _packageName;
    private final List<ClassLocation> _classLocations = new LinkedList<ClassLocation>();

    public ClassLocator(String ... packageNames) throws ClassNotFoundException {
        this(Thread.currentThread().getContextClassLoader(), packageNames);
    }

    public ClassLocator(ClassLoader classLoader, String ... packageNames) throws ClassNotFoundException {
        this._classLoader = classLoader;
        this._packageNames = packageNames;
        if (classLoader == null) {
            throw new ClassNotFoundException("Can't get class loader.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClassLocation> getAllClassLocations() throws ClassNotFoundException, IOException {
        ClassLocator classLocator = this;
        synchronized (classLocator) {
            this._classLocations.clear();
            String[] stringArray = this._packageNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String packageName;
                this._packageName = packageName = stringArray[i];
                String path = packageName.replace('.', '/');
                Enumeration<URL> resources = this._classLoader.getResources(path);
                if (resources == null) {
                    throw new ClassNotFoundException("No resource for " + path);
                }
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (resource.getProtocol().equalsIgnoreCase("FILE")) {
                        this.loadDirectory(resource);
                        continue;
                    }
                    if (resource.getProtocol().equalsIgnoreCase("JAR")) {
                        this.loadJar(resource);
                        continue;
                    }
                    throw new ClassNotFoundException("Unknown protocol on class resource: " + resource.toExternalForm());
                }
            }
            return this._classLocations;
        }
    }

    private void loadJar(URL resource) throws IOException {
        JarURLConnection conn = (JarURLConnection)resource.openConnection();
        JarFile jarFile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        String packagePath = this._packageName.replace('.', '/');
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(packagePath) || entry.getName().endsWith("/")) continue;
            URL url = new URL("jar:" + new URL("file", null, ClassLocator.slashify(jarFile.getName())).toExternalForm() + "!/" + entry.getName());
            String className = entry.getName();
            className = StringUtil.trimStart((String)className, (String)"/");
            className = PathUtils.toUnixPath(className);
            className = PathUtils.getLastPathElement(className);
            className = className.substring(0, className.lastIndexOf(46));
            ClassLocation classLocation = new ClassLocation(this._classLoader, className, url);
            this.addClassLocation(classLocation);
        }
    }

    private void loadDirectory(URL resource) throws IOException {
        this.loadDirectory(this._packageName, resource.getFile());
    }

    private void loadDirectory(String packageName, String fullPath) throws IOException {
        File[] files;
        File directory = new File(fullPath);
        if (!directory.isDirectory()) {
            throw new IOException("Invalid directory " + directory.getAbsolutePath());
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                this.loadDirectory(packageName + '.' + file.getName(), file.getAbsolutePath());
                continue;
            }
            String simpleName = file.getName();
            simpleName = simpleName.substring(0, simpleName.lastIndexOf(46));
            ClassLocation location = new ClassLocation(this._classLoader, simpleName, new URL("file", null, file.getAbsolutePath()));
            this.addClassLocation(location);
        }
    }

    private void addClassLocation(ClassLocation classLocation) throws IOException {
        if (this._classLocations.contains(classLocation)) {
            throw new IOException("Duplicate location found for: " + classLocation.getClassName());
        }
        this._classLocations.add(classLocation);
    }

    private static String slashify(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string + "/";
    }

    public static class ClassLocation {
        private String className;
        private URL url;
        private ClassLoader classLoader;

        public ClassLocation(ClassLoader classLoader, String className, URL url) {
            this.className = className;
            this.url = url;
            this.classLoader = classLoader;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public URL getUrl() {
            return this.url;
        }

        public void setUrl(URL url) {
            this.url = url;
        }

        public int hashCode() {
            return this.className == null ? 0 : this.className.hashCode();
        }

        public boolean equals(ClassLocation classLocation) {
            if (classLocation == null) {
                return false;
            }
            return this.className.equals(classLocation.className);
        }

        public boolean equals(Object o) {
            if (o instanceof ClassLocation) {
                return this.equals((ClassLocation)o);
            }
            return false;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

