/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TapestryParameter
implements Comparable {
    private static final String PARAMETER_NAME = "name";
    private final IJavaClassType _elementClass;
    private final IJavaField _parameterField;

    public TapestryParameter(IJavaClassType elementClass, IJavaField parameterField) {
        this._elementClass = elementClass;
        this._parameterField = parameterField;
    }

    public String getName() {
        Map<String, String[]> params;
        if (!this._parameterField.isValid()) {
            return "";
        }
        String name = this._parameterField.getName();
        IJavaAnnotation annotation = this.getParamAnnotation();
        if (annotation != null && (params = annotation.getParameters()).containsKey(PARAMETER_NAME)) {
            name = params.get(PARAMETER_NAME)[0];
        }
        return name.startsWith("$") || name.startsWith("_") ? name.substring(1) : name;
    }

    public String getDescription() {
        if (!this._parameterField.isValid()) {
            return "";
        }
        return this._parameterField.getDocumentation();
    }

    public IJavaField getParameterField() {
        return this._parameterField;
    }

    public boolean isRequired() {
        if (!this._parameterField.isValid()) {
            return false;
        }
        IJavaAnnotation annotation = this.getParamAnnotation();
        if (annotation == null) {
            return false;
        }
        String[] parameterValue = annotation.getParameters().get("required");
        boolean required = parameterValue != null && parameterValue[0].equals(Boolean.TRUE.toString());
        return required && !TapestryParameter.hasMethod(this._elementClass, this.getName());
    }

    @Nullable
    private IJavaAnnotation getParamAnnotation() {
        return this._parameterField.getAnnotations().get("org.apache.tapestry5.annotations.Parameter");
    }

    public String getDefaultPrefix() {
        String[] parameterValue;
        if (!this._parameterField.isValid()) {
            return "";
        }
        IJavaAnnotation annotation = this.getParamAnnotation();
        if (annotation != null && (parameterValue = annotation.getParameters().get("defaultPrefix")) != null) {
            return parameterValue[0];
        }
        return "prop";
    }

    public String getDefaultValue() {
        String[] parameterValue;
        if (!this._parameterField.isValid()) {
            return "";
        }
        IJavaAnnotation annotation = this.getParamAnnotation();
        if (annotation != null && (parameterValue = annotation.getParameters().get("value")) != null) {
            return parameterValue[0];
        }
        return "";
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((TapestryParameter)o).getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof TapestryParameter && this.getName().equals(((TapestryParameter)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private static boolean hasMethod(IJavaClassType clazz, String methodName) {
        String methodOfParameter = "default" + StringUtil.capitalize((String)StringUtil.notNullize((String)methodName));
        Collection<IJavaMethod> methods = clazz.getAllMethods(true);
        for (IJavaMethod method : methods) {
            if (!method.getName().equals(methodOfParameter) || !method.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

