/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.events;

import com.intellij.tapestry.core.events.FileSystemListener;
import com.intellij.tapestry.core.events.TapestryModelChangeListener;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class TapestryEventsManager
implements FileSystemListener,
TapestryModelChangeListener {
    private final List<FileSystemListener> _fileSystemListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<TapestryModelChangeListener> _tapestryModelChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public synchronized void addTapestryModelListener(TapestryModelChangeListener listener) {
        this._tapestryModelChangeListeners.add(listener);
    }

    public synchronized boolean removeTapestryModelListener(TapestryModelChangeListener listener) {
        return this._tapestryModelChangeListeners.remove(listener);
    }

    public synchronized void addFileSystemListener(FileSystemListener listener) {
        this._fileSystemListeners.add(listener);
    }

    public synchronized boolean removeFileSystemListener(FileSystemListener listener) {
        return this._fileSystemListeners.remove(listener);
    }

    @Override
    public synchronized void fileCreated(String path) {
        for (FileSystemListener listener : this._fileSystemListeners) {
            listener.fileCreated(path);
        }
    }

    @Override
    public synchronized void classDeleted(String classFqn) {
        for (FileSystemListener listener : this._fileSystemListeners) {
            listener.classDeleted(classFqn);
        }
    }

    @Override
    public synchronized void fileDeleted(String path) {
        for (FileSystemListener listener : this._fileSystemListeners) {
            listener.fileDeleted(path);
        }
    }

    @Override
    public synchronized void classCreated(String classFqn) {
        for (FileSystemListener listener : this._fileSystemListeners) {
            listener.classCreated(classFqn);
        }
    }

    @Override
    public synchronized void fileContentsChanged(IResource changedFile) {
        for (FileSystemListener listener : this._fileSystemListeners) {
            listener.fileContentsChanged(changedFile);
        }
    }

    @Override
    public synchronized void modelChanged() {
        for (TapestryModelChangeListener listener : this._tapestryModelChangeListeners) {
            listener.modelChanged();
        }
    }
}

