/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.javascript.debugger.nashorn.NashornDebuggerSupportWrapper;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

final class NashornArray
extends NashornObject
implements ArrayValue {
    private static final PromiseManager<NashornArray, List<Variable>> INDEXED_VARIABLES_LOADER = new PromiseManager<NashornArray, List<Variable>>(NashornArray.class){

        public boolean isUpToDate(@NotNull NashornArray host, @NotNull List<Variable> data) {
            if (host == null) {
                1.$$$reportNull$$$0(0);
            }
            if (data == null) {
                1.$$$reportNull$$$0(1);
            }
            return ((JdiValueManager)host.getChildrenManager().valueManager).getCacheStamp() == host.indexedVariableCacheStamp;
        }

        @NotNull
        public Promise<List<Variable>> load(@NotNull NashornArray host) {
            if (host == null) {
                1.$$$reportNull$$$0(2);
            }
            AsyncPromise asyncPromise = host.loadIndexedVariables();
            if (asyncPromise == null) {
                1.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornArray$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornArray$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUpToDate";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private volatile Promise<List<? extends Variable>> indexedVariables;
    private volatile int indexedVariableCacheStamp;
    private final int length;

    NashornArray(int length, @NotNull ObjectReference objectReference, @Nullable String valueString, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager) {
        if (objectReference == null) {
            NashornArray.$$$reportNull$$$0(0);
        }
        if (threadReference == null) {
            NashornArray.$$$reportNull$$$0(1);
        }
        if (valueManager == null) {
            NashornArray.$$$reportNull$$$0(2);
        }
        super(ValueType.ARRAY, objectReference, valueString, threadReference, valueManager);
        this.indexedVariableCacheStamp = -1;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @NotNull
    public Promise<Void> getIndexedProperties(int from, int to, int bucketThreshold, @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
        if (consumer == null) {
            NashornArray.$$$reportNull$$$0(3);
        }
        Promise result = INDEXED_VARIABLES_LOADER.get((Object)this);
        Promise promise = result.onSuccess(variables -> {
            if (consumer == null) {
                NashornArray.$$$reportNull$$$0(6);
            }
            if (!consumer.isObsolete()) {
                consumer.consumeVariables(variables);
            }
        });
        if (promise == null) {
            NashornArray.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    private AsyncPromise<List<Variable>> loadIndexedVariables() {
        final AsyncPromise promise = new AsyncPromise();
        final JdiValueManager valueManager = (JdiValueManager)this.getChildrenManager().valueManager;
        valueManager.getManagerThread().schedule((DebuggerCommandImpl)new DebuggerContextCommandImpl(valueManager.getDebugProcess().getDebuggerContext()){

            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    NashornDebuggerSupportWrapper debuggerSupport = NashornDebuggerSupportWrapper.get(NashornArray.this.threadReference, valueManager, (EvaluationContext)this.getDebuggerContext().createEvaluationContext());
                    ArrayReference values = debuggerSupport.getIndexedValues(NashornArray.this.objectReference, NashornArray.this.threadReference, 0, NashornArray.this.length);
                    int loadedLength = values.length();
                    if (loadedLength == 0) {
                        NashornArray.this.indexedVariableCacheStamp = valueManager.getCacheStamp();
                        promise.setResult(Collections.emptyList());
                        return;
                    }
                    Variable[] variables = new Variable[loadedLength];
                    List<com.sun.jdi.Value> valueDescriptors = values.getValues();
                    int size = valueDescriptors.size();
                    for (int i = 0; i < size; ++i) {
                        ObjectReference valueDescriptor = (ObjectReference)valueDescriptors.get(i);
                        Map<Field, com.sun.jdi.Value> fieldToValue = debuggerSupport.getValues(valueDescriptor);
                        Value value = NashornObject.createValue(NashornArray.this.threadReference, valueManager, debuggerSupport, fieldToValue);
                        variables[i] = new VariableImpl(Integer.toString(debuggerSupport.getIndex(fieldToValue)), value, null);
                    }
                    NashornArray.this.indexedVariableCacheStamp = valueManager.getCacheStamp();
                    promise.setResult(Arrays.asList(variables));
                }
                catch (Exception e) {
                    promise.setError((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/javascript/debugger/nashorn/NashornArray$2", "threadAction"));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NashornArray.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadIndexedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedProperties";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIndexedProperties$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

