/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtGradleSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "gradle";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;

    public GwtGradleSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myVersion = version;
    }

    @NotNull
    public static String getSdkUrl(@NotNull String pathToGwtJar, boolean fromMaven) {
        if (pathToGwtJar == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(0);
        }
        File gwtJar = new File(pathToGwtJar);
        File gwtJarDir = fromMaven ? gwtJar.getParentFile() : gwtJar.getParentFile().getParentFile();
        String version = gwtJarDir.getName();
        File gwtDevDir = new File(gwtJarDir.getParentFile().getParentFile(), "gwt-dev/" + version);
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)gwtDevDir.getAbsolutePath()));
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String string = this.getArtifactPath("gwt-dev");
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String getArtifactPath(String name) {
        String path = GwtGradleSdkPaths.getArtifactPath(new File(this.myBasePath), name, this.myVersion, null);
        if (path != null) {
            String string = path;
            if (string == null) {
                GwtGradleSdkPaths.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = new File(this.myBasePath, name + "/" + this.myVersion).getAbsolutePath();
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getArtifactPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getArtifactPath("gwt-servlet");
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static String getArtifactPath(@NotNull File baseDir, @NotNull String name, @NotNull String version, @Nullable String suffix) {
        File[] subDirs;
        if (baseDir == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(7);
        }
        if (name == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(8);
        }
        if (version == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(9);
        }
        if ((subDirs = new File(baseDir, name + "/" + version).listFiles()) != null) {
            for (File subDir : subDirs) {
                File jar = new File(subDir, name + "-" + version + (suffix != null ? "-" + suffix : "") + ".jar");
                if (!jar.exists()) continue;
                return jar.getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getArtifactPath("gwt-user");
        if (string == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String preferredVersion;
        ArrayList<String> additionalJars = new ArrayList<String>();
        ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath("javax.validation", "validation-api", null, null));
        ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath("javax.validation", "validation-api", null, "sources"));
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.7.0") >= 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_7_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion, null));
            }
        }
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.8.0-beta1") > 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_8_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion, null));
            }
        }
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private String getArtifactPath(@NotNull String groupId, @NotNull String artifactId, @Nullable String preferredVersion, @Nullable String suffix) {
        File dir;
        String[] dirNames;
        if (groupId == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(12);
        }
        if (artifactId == null) {
            GwtGradleSdkPaths.$$$reportNull$$$0(13);
        }
        if ((dirNames = new File(dir = new File(PathUtilRt.getParentPath((String)this.myBasePath), groupId), artifactId).list()) != null && dirNames.length > 0) {
            String path;
            if (preferredVersion != null && ArrayUtil.contains((String)preferredVersion, (String[])dirNames) && (path = GwtGradleSdkPaths.getArtifactPath(dir, artifactId, preferredVersion, suffix)) != null) {
                return path;
            }
            String version = Collections.max(Arrays.asList(dirNames), VersionComparatorUtil.COMPARATOR);
            return GwtGradleSdkPaths.getArtifactPath(dir, artifactId, version, suffix);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGwtJar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevJarPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectoryUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletJarPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserJarPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCompilerJars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkUrl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

