/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.MethodIntf;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbMethodResolveConverter
extends AbstractMethodResolveConverter<Method> {
    public EjbMethodResolveConverter() {
        super(Method.class);
    }

    @NotNull
    protected Collection<PsiClass> getPsiClasses(Method parent, ConvertContext context) {
        Collection<PsiClass> collection = EjbMethodResolveConverter.getTargetClasses((EnterpriseBean)parent.getEnterpriseBean().getValue(), (MethodIntf)((Object)parent.getMethodIntf().getValue()), true);
        if (collection == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public static Collection<PsiClass> getTargetClasses(@Nullable EnterpriseBean ejb, @Nullable MethodIntf methodIntf, boolean includeEjbClass) {
        HashSet<PsiClass> targetClasses = new HashSet<PsiClass>();
        boolean allInterfaces = false;
        MethodIntf curMethodIntf = methodIntf;
        if (methodIntf == null) {
            allInterfaces = true;
            curMethodIntf = MethodIntf.HOME;
            if (includeEjbClass && ejb != null) {
                targetClasses.add((PsiClass)ejb.getEjbClass().getValue());
            }
        }
        switch (curMethodIntf) {
            case HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((EjbWithHome)ejb).getHome().getValue());
                }
                if (!allInterfaces) break;
            }
            case LOCAL_HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((EjbWithHome)ejb).getLocalHome().getValue());
                }
                if (!allInterfaces) break;
            }
            case REMOTE: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((EjbWithHome)ejb).getRemote().getValue());
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessRemotes()) {
                        ContainerUtil.addIfNotNull(targetClasses, (Object)genericValue.getValue());
                    }
                }
                if (!allInterfaces) break;
            }
            case LOCAL: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((EjbWithHome)ejb).getLocal().getValue());
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessLocals()) {
                        ContainerUtil.addIfNotNull(targetClasses, (Object)genericValue.getValue());
                    }
                } else if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue());
                }
                if (!allInterfaces) break;
            }
            case SERVICE_ENDPOINT: {
                if (ejb instanceof SessionBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((SessionBean)ejb).getServiceEndpoint().getValue());
                }
                if (!allInterfaces) break;
            }
            case MESSAGE_ENDPOINT: {
                if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue());
                }
                if (!allInterfaces) break;
            }
            case TIMER: {
                if (allInterfaces || ejb == null) break;
                ContainerUtil.addIfNotNull(targetClasses, (Object)ejb.getEjbClass().getValue());
            }
        }
        return targetClasses;
    }

    @NotNull
    protected MethodParams getMethodParams(@NotNull Method parent) {
        if (parent == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(1);
        }
        MethodParams methodParams = parent.getMethodParams();
        if (methodParams == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(2);
        }
        return methodParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/model/EjbMethodResolveConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/model/EjbMethodResolveConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodParams";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMethodParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

