/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.BasicDataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import icons.AndroidIcons;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceConfigurable;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDataSourceManager
extends BasicDataSourceManager<AndroidDataSource> {
    public static final String NOTIFICATION_GROUP_ID = "Android Data Source Manager";
    private final AndroidDataSourceStorage myStorage;

    public AndroidDataSourceManager(@NotNull Project project, @NotNull AndroidDataSourceStorage storage) {
        if (project == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(1);
        }
        super(project, storage.getDataSources());
        this.myStorage = storage;
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(2);
        }
        return DbImplUtil.getDatabaseDialect((Dbms)Dbms.SQLITE);
    }

    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(3);
        }
        return DbSqlUtil.findSqlDialect((Dbms)Dbms.SQLITE);
    }

    public void renameDataSource(@NotNull AndroidDataSource element, @NotNull String name) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(5);
        }
        element.setName(name);
        this.updateDataSource((DasDataSource)element);
    }

    public void addDataSource(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(6);
        }
        this.myStorage.addDataSource(dataSource);
        this.attachDataSource((DasDataSource)dataSource);
    }

    public void removeDataSource(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(7);
        }
        this.myStorage.removeDataSource(element);
        this.detachDataSource((DasDataSource)element);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(8);
        }
        AndroidDataSourceConfigurable androidDataSourceConfigurable = new AndroidDataSourceConfigurable(this, this.myProject, element);
        if (androidDataSourceConfigurable == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(9);
        }
        return androidDataSourceConfigurable;
    }

    public AnAction getCreateDataSourceAction(final @NotNull Consumer<AndroidDataSource> consumer) {
        if (consumer == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(10);
        }
        if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
            return null;
        }
        return new DumbAwareAction("Android SQLite", null, AndroidIcons.Android){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AndroidDataSource result = new AndroidDataSource();
                result.setName(this.getTemplatePresentation().getText());
                result.resolveDriver();
                consumer.consume((Object)result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/database/AndroidDataSourceManager$1", "actionPerformed"));
            }
        };
    }

    @NotNull
    public AndroidDataSource copyDataSource(@NotNull String newName, @NotNull AndroidDataSource copyFrom) {
        if (newName == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(11);
        }
        if (copyFrom == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(12);
        }
        AndroidDataSource result = copyFrom.copy();
        result.setName(newName);
        result.resolveDriver();
        AndroidDataSource androidDataSource = result;
        if (androidDataSource == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(13);
        }
        return androidDataSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSourceManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSourceManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

