/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.tiles;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TilesResultContributor
extends StrutsResultContributor {
    @NonNls
    private static final String TILES_RESULT_TYPE = "tiles";

    @Override
    protected boolean matchesResultType(@NotNull @NonNls String resultType) {
        if (resultType == null) {
            TilesResultContributor.$$$reportNull$$$0(0);
        }
        return Comparing.equal((String)resultType, (String)TILES_RESULT_TYPE);
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> psiReferences, boolean soft) {
        String currentPackage;
        if (psiElement == null) {
            TilesResultContributor.$$$reportNull$$$0(1);
        }
        if (psiReferences == null) {
            TilesResultContributor.$$$reportNull$$$0(2);
        }
        if ((currentPackage = this.getNamespace(psiElement)) == null) {
            return false;
        }
        List<TilesModel> allTilesModels = TilesResultContributor.getAllTilesModels(psiElement);
        psiReferences.add((PsiReference)new TilesDefinitionReference((XmlTag)psiElement, allTilesModels));
        return true;
    }

    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement psiElement) {
        if (path == null) {
            TilesResultContributor.$$$reportNull$$$0(3);
        }
        if (psiElement == null) {
            TilesResultContributor.$$$reportNull$$$0(4);
        }
        return this.createDefaultPathReference(path, psiElement, StrutsApiIcons.Tiles.Tile);
    }

    private static List<TilesModel> getAllTilesModels(@NotNull PsiElement psiElement) {
        Module module;
        if (psiElement == null) {
            TilesResultContributor.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) == null) {
            return Collections.emptyList();
        }
        return StrutsManager.getInstance().getAllTilesModels(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReferences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/struts2/tiles/TilesResultContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesResultType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllTilesModels";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TilesDefinitionReference
    extends PsiReferenceBase<XmlTag>
    implements EmptyResolveMessageProvider {
        private final List<TilesModel> allTilesModels;
        private final String definitionName;
        private static final Function<TilesModel, Collection<? extends Definition>> DEFINITION_COLLECTOR = tilesModel -> tilesModel.getDefinitions();

        private TilesDefinitionReference(@NotNull XmlTag xmlElement, @NotNull List<TilesModel> allTilesModels) {
            if (xmlElement == null) {
                TilesDefinitionReference.$$$reportNull$$$0(0);
            }
            if (allTilesModels == null) {
                TilesDefinitionReference.$$$reportNull$$$0(1);
            }
            super((PsiElement)xmlElement, true);
            this.allTilesModels = allTilesModels;
            this.definitionName = xmlElement.getValue().getTrimmedText();
        }

        public PsiElement resolve() {
            for (TilesModel tilesModel : this.allTilesModels) {
                XmlTag definition = tilesModel.getTileTag(this.definitionName);
                if (definition == null) continue;
                return definition;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List definitions = ContainerUtil.concat(this.allTilesModels, DEFINITION_COLLECTOR);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
            for (Definition definition : definitions) {
                String definitionName = definition.getName().getStringValue();
                XmlElement xmlElement = definition.getXmlElement();
                assert (xmlElement != null);
                PsiFile psiFile = xmlElement.getContainingFile();
                if (psiFile == null || !StringUtil.isNotEmpty((String)definitionName)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)definition, (String)definitionName).withIcon(StrutsApiIcons.Tiles.Tile).withTypeText(psiFile.getName());
                variants.add(builder);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                TilesDefinitionReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve Tiles definition '" + this.getValue() + "'";
            if (string == null) {
                TilesDefinitionReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allTilesModels";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

