/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.struts2.facet.StrutsFacetLibrariesValidatorDescription;
import com.intellij.struts2.facet.ui.FeaturesConfigurationTab;
import com.intellij.struts2.facet.ui.FileSetConfigurationTab;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class StrutsFacetConfiguration
extends SimpleModificationTracker
implements FacetConfiguration,
ModificationTracker,
Disposable {
    @NonNls
    private static final String FILESET = "fileset";
    @NonNls
    private static final String SET_ID = "id";
    @NonNls
    private static final String SET_NAME = "name";
    @NonNls
    private static final String SET_REMOVED = "removed";
    @NonNls
    private static final String FILE = "file";
    private final Set<StrutsFileSet> myFileSets = new LinkedHashSet<StrutsFileSet>();
    private static final String PROPERTIES_KEYS = "propertiesKeys";
    private static final String PROPERTIES_KEYS_DISABLED = "disabled";
    private boolean myPropertiesKeysDisabled = false;

    public Set<StrutsFileSet> getFileSets() {
        return this.myFileSets;
    }

    public boolean isPropertiesKeysDisabled() {
        return this.myPropertiesKeysDisabled;
    }

    public void setPropertiesKeysDisabled(boolean myPropertiesKeysDisabled) {
        this.myPropertiesKeysDisabled = myPropertiesKeysDisabled;
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        FacetLibrariesValidator validator = FacetEditorsFactory.getInstance().createLibrariesValidator(LibraryInfo.EMPTY_ARRAY, (FacetLibrariesValidatorDescription)new StrutsFacetLibrariesValidatorDescription(), editorContext, validatorsManager);
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        return new FacetEditorTab[]{new FileSetConfigurationTab(this, editorContext), new FeaturesConfigurationTab(this)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (Object setElement : element.getChildren(FILESET)) {
            String setName = ((Element)setElement).getAttributeValue(SET_NAME);
            String setId = ((Element)setElement).getAttributeValue(SET_ID);
            String removed = ((Element)setElement).getAttributeValue(SET_REMOVED);
            if (setName == null || setId == null) continue;
            StrutsFileSet fileSet = new StrutsFileSet(setId, setName, this);
            List files = ((Element)setElement).getChildren(FILE);
            for (Object fileElement : files) {
                String text = ((Element)fileElement).getText();
                fileSet.addFile(text);
            }
            fileSet.setRemoved(Boolean.valueOf(removed));
            this.myFileSets.add(fileSet);
        }
        Element propertiesElement = element.getChild(PROPERTIES_KEYS);
        if (propertiesElement != null) {
            String disabled = propertiesElement.getAttributeValue(PROPERTIES_KEYS_DISABLED);
            this.myPropertiesKeysDisabled = Boolean.valueOf(disabled);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (StrutsFileSet fileSet : this.myFileSets) {
            Element setElement = new Element(FILESET);
            setElement.setAttribute(SET_ID, fileSet.getId());
            setElement.setAttribute(SET_NAME, fileSet.getName());
            setElement.setAttribute(SET_REMOVED, Boolean.toString(fileSet.isRemoved()));
            element.addContent(setElement);
            for (VirtualFilePointer fileName : fileSet.getFiles()) {
                Element fileElement = new Element(FILE);
                fileElement.setText(fileName.getUrl());
                setElement.addContent(fileElement);
            }
        }
        Element propertiesElement = new Element(PROPERTIES_KEYS);
        propertiesElement.setAttribute(PROPERTIES_KEYS_DISABLED, Boolean.toString(this.myPropertiesKeysDisabled));
        element.addContent(propertiesElement);
    }

    public void setModified() {
        this.incModificationCount();
    }

    public void dispose() {
    }
}

