/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts2.dom.ExtendableClassConverter;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendableClassConverterImpl
extends ExtendableClassConverter {
    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass psiClass = DomJavaUtil.findClass((String)s, (DomElement)context.getInvocationElement());
        if (psiClass != null) {
            return psiClass;
        }
        XmlElement element = context.getReferenceXmlElement();
        assert (element != null);
        ExtendClass extendClass = ExtendableClassConverterImpl.getExtendsAnnotation(context.getInvocationElement());
        for (ExtendableClassConverter.ExtendableClassConverterContributor contributor : EP_NAME.getExtensionList()) {
            PsiElement resolveElement;
            PsiReference[] add;
            if (!contributor.isSuitable(context) || (add = contributor.getReferences(context, (PsiElement)element, extendClass)).length != 1 || (resolveElement = add[0].resolve()) == null) continue;
            return (PsiClass)resolveElement;
        }
        return null;
    }

    public String toString(@Nullable PsiClass psiClass, ConvertContext context) {
        return psiClass != null ? psiClass.getQualifiedName() : null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiClass> psiClassGenericDomValue, PsiElement element, ConvertContext context) {
        Object[] objectArray;
        ExtendClass extendClass = ExtendableClassConverterImpl.getExtendsAnnotation(psiClassGenericDomValue);
        final GlobalSearchScope scope = ExtendableClassConverterImpl.getResolveScope(psiClassGenericDomValue);
        JavaClassReferenceProvider classReferenceProvider = new JavaClassReferenceProvider(){

            public GlobalSearchScope getScope(Project project) {
                return scope;
            }
        };
        PsiClassConverter.createJavaClassReferenceProvider(psiClassGenericDomValue, (ExtendClass)extendClass, (JavaClassReferenceProvider)classReferenceProvider);
        Object[] javaClassReferences = classReferenceProvider.getReferencesByElement(element);
        boolean allowInterface = extendClass.allowInterface();
        if (allowInterface) {
            String[] stringArray = new String[2];
            stringArray[0] = "class";
            objectArray = stringArray;
            stringArray[1] = "interface";
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = "class";
        }
        Object[] referenceTypes = objectArray;
        for (ExtendableClassConverter.ExtendableClassConverterContributor contributor : EP_NAME.getExtensionList()) {
            if (!contributor.isSuitable(context)) continue;
            Object[] additionalReferences = contributor.getReferences(context, element, extendClass);
            javaClassReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])javaClassReferences, (Object[])additionalReferences, (ArrayFactory)PsiReference.ARRAY_FACTORY);
            referenceTypes = (String[])ArrayUtil.append((Object[])referenceTypes, (Object)contributor.getTypeName(), (ArrayFactory)ArrayUtil.STRING_ARRAY_FACTORY);
        }
        psiClassGenericDomValue.putUserData(REFERENCES_TYPES, (Object)referenceTypes);
        if (javaClassReferences == null) {
            ExtendableClassConverterImpl.$$$reportNull$$$0(0);
        }
        return javaClassReferences;
    }

    @NotNull
    private static ExtendClass getExtendsAnnotation(DomElement psiClassDomElement) {
        ExtendClass extendClass = (ExtendClass)psiClassDomElement.getAnnotation(ExtendClass.class);
        assert (extendClass != null) : psiClassDomElement + " must be annotated with @ExtendClass";
        ExtendClass extendClass2 = extendClass;
        if (extendClass2 == null) {
            ExtendableClassConverterImpl.$$$reportNull$$$0(1);
        }
        return extendClass2;
    }

    @Nullable
    private static GlobalSearchScope getResolveScope(GenericDomValue genericdomvalue) {
        Module module = genericdomvalue.getModule();
        return module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsAnnotation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

