/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.ConverterUtil;
import com.intellij.struts2.dom.ExtendableClassConverter;
import com.intellij.struts2.dom.struts.Bean;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.strutspackage.DefaultClassRef;
import com.intellij.struts2.dom.struts.strutspackage.Interceptor;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;

class Struts2ModelInspectionVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder holder;
    private final boolean myIgnoreExtendableClass;

    Struts2ModelInspectionVisitor(DomElementAnnotationHolder holder, boolean ignoreExtendableClass) {
        this.holder = holder;
        this.myIgnoreExtendableClass = ignoreExtendableClass;
    }

    public void visitDomElement(DomElement element) {
    }

    public void visitAction(Action action) {
        GenericAttributeValue actionClass = action.getActionClass();
        if (action.isWildcardMapping() && ConverterUtil.hasWildcardReference(actionClass.getStringValue())) {
            return;
        }
        this.checkExtendableClassConverter(actionClass);
    }

    public void visitBean(Bean bean) {
        this.checkExtendableClassConverter(bean.getBeanClass());
    }

    public void visitDefaultClassRef(DefaultClassRef defaultClassRef) {
        this.checkExtendableClassConverter(defaultClassRef.getDefaultClass());
    }

    public void visitInterceptor(Interceptor interceptor) {
        this.checkExtendableClassConverter(interceptor.getInterceptorClass());
    }

    public void visitResultType(ResultType resultType) {
        this.checkExtendableClassConverter(resultType.getResultTypeClass());
    }

    public void visitStrutsPackage(StrutsPackage strutsPackage) {
        String namespace = strutsPackage.getNamespace().getStringValue();
        if (namespace != null && !StringUtil.startsWithChar((CharSequence)namespace, (char)'/')) {
            this.holder.createProblem((DomElement)strutsPackage.getNamespace(), StrutsBundle.message("dom.highlighting.struts.package.must.start.with.slash", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void checkExtendableClassConverter(GenericAttributeValue clazzAttributeValue) {
        PsiReference[] psiReferences;
        if (this.myIgnoreExtendableClass) {
            return;
        }
        XmlElement xmlElement = DomUtil.getValueElement((GenericDomValue)clazzAttributeValue);
        if (xmlElement == null) {
            return;
        }
        for (PsiReference psiReference : psiReferences = xmlElement.getReferences()) {
            PsiElement resolveElement = psiReference.resolve();
            if (!(resolveElement instanceof PsiClass)) continue;
            return;
        }
        String[] referenceTypesUserData = (String[])clazzAttributeValue.getUserData(ExtendableClassConverter.REFERENCES_TYPES);
        String referenceTypes = referenceTypesUserData != null ? StringUtil.join((String[])referenceTypesUserData, (String)"|") : StrutsBundle.message("dom.extendable.class.converter.type.class", new Object[0]);
        String message = StrutsBundle.message("dom.extendable.class.converter.cannot.resolve", referenceTypes, clazzAttributeValue.getStringValue());
        Object[] quickFixes = LocalQuickFix.EMPTY_ARRAY;
        for (PsiReference psiReference : psiReferences) {
            Object[] fixes;
            if (!(psiReference instanceof LocalQuickFixProvider) || (fixes = ((LocalQuickFixProvider)psiReference).getQuickFixes()) == null) continue;
            quickFixes = (LocalQuickFix[])ArrayUtil.mergeArrays((Object[])fixes, (Object[])quickFixes);
        }
        this.holder.createProblem((DomElement)clazzAttributeValue, message, (LocalQuickFix[])quickFixes);
    }
}

