/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiMethodUtil;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0002*\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0002*\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\r*\u00020\u001f\u001a\f\u0010 \u001a\u0004\u0018\u00010!*\u00020\r\u001a\f\u0010\"\u001a\u0004\u0018\u00010#*\u00020\r\u001a\f\u0010$\u001a\u0004\u0018\u00010#*\u00020\r\u001a\n\u0010%\u001a\u00020\u000b*\u00020&\u001a\u0012\u0010'\u001a\u00020\u000b*\u00020&2\u0006\u0010(\u001a\u00020)\u001a\n\u0010*\u001a\u00020\u000b*\u00020\r\u001a\n\u0010+\u001a\u00020\u000b*\u00020#\u001a\n\u0010,\u001a\u00020\u000b*\u00020-\u001a\u0012\u0010.\u001a\u00020\u000b*\u00020\u001f2\u0006\u0010/\u001a\u00020!\u001a\n\u00100\u001a\u00020\u000b*\u00020\u001f\u001a\f\u00101\u001a\u0004\u0018\u00010\r*\u000202\u001a\f\u00103\u001a\u0004\u0018\u00010\r*\u000202\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"toKotlinMutableTypesMap", "", "", "getToKotlinMutableTypesMap", "()Ljava/util/Map;", "toKotlinTypesMap", "getDefaultInitializer", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "property", "Lorg/jetbrains/kotlin/j2k/ast/Property;", "isFacadeClassFromLibrary", "", "element", "Lcom/intellij/psi/PsiElement;", "quoteKeywords", "packageName", "shouldGenerateDefaultInitializer", "searcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "field", "Lcom/intellij/psi/PsiField;", "accessModifier", "Lcom/intellij/psi/PsiModifierListOwner;", "convertToKotlinAnalog", "Lorg/jetbrains/kotlin/j2k/Converter;", "classQualifiedName", "mutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "convertToKotlinAnalogIdentifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "dot", "Lcom/intellij/psi/PsiReferenceExpression;", "getContainingClass", "Lcom/intellij/psi/PsiClass;", "getContainingConstructor", "Lcom/intellij/psi/PsiMethod;", "getContainingMethod", "isConstructor", "Lcom/intellij/psi/PsiMember;", "isImported", "file", "Lcom/intellij/psi/PsiJavaFile;", "isInSingleLine", "isMainMethod", "isNullLiteral", "Lcom/intellij/psi/PsiExpression;", "isQualifierEmptyOrClass", "psiClass", "isQualifierEmptyOrThis", "lPar", "Lcom/intellij/psi/PsiExpressionList;", "rPar", "j2k"})
public final class UtilsKt {
    private static final Map<String, String> toKotlinTypesMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Object", (Object)KotlinBuiltIns.FQ_NAMES.any.asString()), TuplesKt.to((Object)"java.lang.Byte", (Object)KotlinBuiltIns.FQ_NAMES._byte.asString()), TuplesKt.to((Object)"java.lang.Character", (Object)KotlinBuiltIns.FQ_NAMES._char.asString()), TuplesKt.to((Object)"java.lang.Double", (Object)KotlinBuiltIns.FQ_NAMES._double.asString()), TuplesKt.to((Object)"java.lang.Float", (Object)KotlinBuiltIns.FQ_NAMES._float.asString()), TuplesKt.to((Object)"java.lang.Integer", (Object)KotlinBuiltIns.FQ_NAMES._int.asString()), TuplesKt.to((Object)"java.lang.Long", (Object)KotlinBuiltIns.FQ_NAMES._long.asString()), TuplesKt.to((Object)"java.lang.Short", (Object)KotlinBuiltIns.FQ_NAMES._short.asString()), TuplesKt.to((Object)"java.lang.Boolean", (Object)KotlinBuiltIns.FQ_NAMES._boolean.asString()), TuplesKt.to((Object)"java.lang.Iterable", (Object)KotlinBuiltIns.FQ_NAMES.iterable.asString()), TuplesKt.to((Object)"java.util.Iterator", (Object)KotlinBuiltIns.FQ_NAMES.iterator.asString()), TuplesKt.to((Object)"java.util.List", (Object)KotlinBuiltIns.FQ_NAMES.list.asString()), TuplesKt.to((Object)"java.util.Collection", (Object)KotlinBuiltIns.FQ_NAMES.collection.asString()), TuplesKt.to((Object)"java.util.Set", (Object)KotlinBuiltIns.FQ_NAMES.set.asString()), TuplesKt.to((Object)"java.util.Map", (Object)KotlinBuiltIns.FQ_NAMES.map.asString()), TuplesKt.to((Object)"java.util.Map.Entry", (Object)KotlinBuiltIns.FQ_NAMES.mapEntry.asString()), TuplesKt.to((Object)ListIterator.class.getCanonicalName(), (Object)KotlinBuiltIns.FQ_NAMES.listIterator.asString())});
    @NotNull
    private static final Map<String, String> toKotlinMutableTypesMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.util.Iterator", (Object)KotlinBuiltIns.FQ_NAMES.mutableIterator.asString()), TuplesKt.to((Object)"java.util.List", (Object)KotlinBuiltIns.FQ_NAMES.mutableList.asString()), TuplesKt.to((Object)"java.util.Collection", (Object)KotlinBuiltIns.FQ_NAMES.mutableCollection.asString()), TuplesKt.to((Object)"java.util.Set", (Object)KotlinBuiltIns.FQ_NAMES.mutableSet.asString()), TuplesKt.to((Object)"java.util.Map", (Object)KotlinBuiltIns.FQ_NAMES.mutableMap.asString()), TuplesKt.to((Object)"java.util.Map.Entry", (Object)KotlinBuiltIns.FQ_NAMES.mutableMapEntry.asString()), TuplesKt.to((Object)ListIterator.class.getCanonicalName(), (Object)KotlinBuiltIns.FQ_NAMES.mutableListIterator.asString())});

    @NotNull
    public static final String quoteKeywords(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)quoteKeywords.1.INSTANCE, (int)30, null);
    }

    @Nullable
    public static final Expression getDefaultInitializer(@NotNull Property property2) {
        Expression result;
        Expression expression;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Type t = property2.getType();
        if (t.isNullable()) {
            expression = new LiteralExpression("null");
        } else if (t instanceof PrimitiveType) {
            switch (((PrimitiveType)t).getName().getName()) {
                case "Boolean": {
                    expression = new LiteralExpression("false");
                    break;
                }
                case "Char": {
                    expression = new LiteralExpression("' '");
                    break;
                }
                case "Double": {
                    Expression expression2 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.DOUBLE.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OperatorConventions.DOUBLE.toString()");
                    expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression2, string, null, null, null, 28, null);
                    break;
                }
                case "Float": {
                    Expression expression3 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                    String string = OperatorConventions.FLOAT.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OperatorConventions.FLOAT.toString()");
                    expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression3, string, null, null, null, 28, null);
                    break;
                }
                default: {
                    expression = new LiteralExpression("0");
                    break;
                }
            }
        } else {
            expression = null;
        }
        Expression expression4 = result = expression;
        return expression4 != null ? (Expression)ElementKt.assignNoPrototype((Element)expression4) : null;
    }

    public static final boolean shouldGenerateDefaultInitializer(@NotNull ReferenceSearcher searcher, @NotNull PsiField field) {
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return field.getInitializer() == null && (ReferenceSearcherKt.isVar(field, searcher) || !ReferenceSearcherKt.hasWriteAccesses((PsiVariable)field, searcher, (PsiElement)field.getContainingClass()));
    }

    public static final boolean isQualifierEmptyOrThis(@NotNull PsiReferenceExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiExpression qualifier = $receiver.getQualifierExpression();
        return qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null;
    }

    public static final boolean isQualifierEmptyOrClass(@NotNull PsiReferenceExpression $receiver, @NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        PsiExpression qualifier = $receiver.getQualifierExpression();
        return qualifier == null || qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)psiClass);
    }

    public static final boolean isInSingleLine(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver instanceof PsiWhiteSpace) {
            String text2;
            String string = ((PsiWhiteSpace)$receiver).getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return StringsKt.indexOf$default((CharSequence)(text2 = string), (char)'\n', (int)0, (boolean)false, (int)6, null) < 0 && StringsKt.indexOf$default((CharSequence)text2, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        }
        for (PsiElement child = $receiver.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (UtilsKt.isInSingleLine(child)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final PsiMethod getContainingMethod(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement context = $receiver.getContext();
        while (context != null) {
            PsiElement _context = context;
            if (_context instanceof PsiMethod) {
                return (PsiMethod)_context;
            }
            context = _context.getContext();
        }
        return null;
    }

    @Nullable
    public static final PsiClass getContainingClass(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement context = $receiver.getContext();
        while (context != null) {
            PsiElement _context = context;
            if (_context instanceof PsiClass) {
                return (PsiClass)_context;
            }
            if (_context instanceof PsiMember) {
                return ((PsiMember)_context).getContainingClass();
            }
            context = _context.getContext();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiMethod getContainingConstructor(@NotNull PsiElement $receiver) {
        PsiMethod method;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiMethod psiMethod = method = UtilsKt.getContainingMethod($receiver);
        if (psiMethod == null) return null;
        if (!psiMethod.isConstructor()) return null;
        PsiMethod psiMethod2 = method;
        return psiMethod2;
    }

    public static final boolean isConstructor(@NotNull PsiMember $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof PsiMethod && ((PsiMethod)$receiver).isConstructor();
    }

    @NotNull
    public static final String accessModifier(@NotNull PsiModifierListOwner $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.hasModifierProperty("public") ? "public" : ($receiver.hasModifierProperty("private") ? "private" : ($receiver.hasModifierProperty("protected") ? "protected" : "packageLocal"));
    }

    public static final boolean isMainMethod(@NotNull PsiMethod $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiMethodUtil.isMainMethod((PsiMethod)$receiver);
    }

    @Nullable
    public static final PsiElement dot(@NotNull PsiReferenceExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = $receiver.getNode().findChildByType(JavaTokenType.DOT);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement lPar(@NotNull PsiExpressionList $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = $receiver.getNode().findChildByType(JavaTokenType.LPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement rPar(@NotNull PsiExpressionList $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = $receiver.getNode().findChildByType(JavaTokenType.RPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImported(@NotNull PsiMember $receiver, @NotNull PsiJavaFile file) {
        PsiImportStaticStatement[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if ($receiver instanceof PsiClass) {
            PsiImportStatementBase[] $receiver$iv2;
            String string;
            int index;
            String fqName;
            String string2 = fqName = ((PsiClass)$receiver).getQualifiedName();
            int n = index = string2 != null ? StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) : -1;
            if (index >= 0) {
                String string3 = fqName;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = string3;
                int n2 = 0;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, index);
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = null;
            }
            String parentName = string;
            PsiImportStatementBase[] psiImportStatementBaseArray = file.getImportList();
            PsiImportStatementBase[] psiImportStatementBaseArray2 = psiImportStatementBaseArray;
            if (psiImportStatementBaseArray == null) return false;
            PsiImportStatementBase[] psiImportStatementBaseArray3 = psiImportStatementBaseArray2.getAllImportStatements();
            psiImportStatementBaseArray2 = psiImportStatementBaseArray3;
            if (psiImportStatementBaseArray3 == null) return false;
            PsiImportStatementBase[] psiImportStatementBaseArray4 = $receiver$iv2 = psiImportStatementBaseArray2;
            int n3 = psiImportStatementBaseArray4.length;
            int n4 = 0;
            while (n4 < n3) {
                PsiImportStatementBase element$iv;
                PsiImportStatementBase it;
                PsiImportStatementBase psiImportStatementBase = it = (element$iv = psiImportStatementBaseArray4[n4]);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiImportStatementBase, (String)"it");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = psiImportStatementBase.getImportReference();
                if (Intrinsics.areEqual((Object)(psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null), (Object)(it.isOnDemand() ? parentName : fqName))) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        if ($receiver.getContainingClass() == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray = file.getImportList();
        PsiImportStaticStatement[] psiImportStaticStatementArray2 = psiImportStaticStatementArray;
        if (psiImportStaticStatementArray == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray3 = psiImportStaticStatementArray2.getImportStaticStatements();
        psiImportStaticStatementArray2 = psiImportStaticStatementArray3;
        if (psiImportStaticStatementArray3 == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray4 = $receiver$iv = psiImportStaticStatementArray2;
        int n = psiImportStaticStatementArray4.length;
        int n5 = 0;
        while (n5 < n) {
            PsiImportStaticStatement element$iv = psiImportStaticStatementArray4[n5];
            PsiImportStaticStatement it = element$iv;
            if (Intrinsics.areEqual((Object)it.resolveTargetClass(), (Object)$receiver.getContainingClass())) {
                PsiImportStaticStatement psiImportStaticStatement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiImportStaticStatement, (String)"it");
                if (psiImportStaticStatement.isOnDemand()) return true;
                if (Intrinsics.areEqual((Object)it.getReferenceName(), (Object)$receiver.getName())) {
                    return true;
                }
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public static final boolean isNullLiteral(@NotNull PsiExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof PsiLiteralExpression && Intrinsics.areEqual((Object)((PsiLiteralExpression)$receiver).getType(), (Object)PsiType.NULL);
    }

    public static final boolean isFacadeClassFromLibrary(@Nullable PsiElement element) {
        return element instanceof KtLightClass && ((KtLightClass)element).getKotlinOrigin() == null;
    }

    @Nullable
    public static final String convertToKotlinAnalog(@NotNull Converter $receiver, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mutability), (String)"mutability");
        if (classQualifiedName == null) {
            return null;
        }
        String string = TypesKt.isMutable(mutability, $receiver.getSettings()) ? toKotlinMutableTypesMap.get(classQualifiedName) : null;
        if (string == null) {
            string = toKotlinTypesMap.get(classQualifiedName);
        }
        return string;
    }

    @Nullable
    public static final Identifier convertToKotlinAnalogIdentifier(@NotNull Converter $receiver, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mutability), (String)"mutability");
        String string = UtilsKt.convertToKotlinAnalog($receiver, classQualifiedName, mutability);
        if (string == null) {
            return null;
        }
        String kotlinClassName = string;
        return Identifier.Companion.withNoPrototype$default(Identifier.Companion, StringsKt.substringAfterLast$default((String)kotlinClassName, (char)'.', null, (int)2, null), false, false, null, 14, null);
    }

    @NotNull
    public static final Map<String, String> getToKotlinMutableTypesMap() {
        return toKotlinMutableTypesMap;
    }
}

