/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import gherkin.deps.com.google.gson.Gson;
import gherkin.util.FixJava;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class URLOutputStream
extends OutputStream {
    private final URL url;
    private final String method;
    private final int expectedResponseCode;
    private final OutputStream out;
    private final HttpURLConnection urlConnection;

    public URLOutputStream(URL url) throws IOException {
        this(url, "PUT", Collections.emptyMap(), 200);
    }

    public URLOutputStream(URL url, String method, Map<String, String> headers, int expectedResponseCode) throws IOException {
        this.url = url;
        this.method = method;
        this.expectedResponseCode = expectedResponseCode;
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            this.ensureParentDirExists(file);
            this.out = new FileOutputStream(file);
            this.urlConnection = null;
        } else if (url.getProtocol().startsWith("http")) {
            this.urlConnection = (HttpURLConnection)url.openConnection();
            this.urlConnection.setRequestMethod(method);
            this.urlConnection.setDoOutput(true);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.urlConnection.setRequestProperty(header.getKey(), header.getValue());
            }
            this.out = this.urlConnection.getOutputStream();
        } else {
            throw new IllegalArgumentException("URL Scheme must be one of file,http,https. " + url.toExternalForm());
        }
    }

    private void ensureParentDirExists(File file) throws IOException {
        boolean ok;
        if (file.getParentFile() != null && !file.getParentFile().isDirectory() && !(ok = file.getParentFile().mkdirs())) {
            throw new IOException("Failed to create directory " + file.getParentFile().getAbsolutePath());
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.out.write(buffer, offset, count);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            int responseCode;
            if (this.urlConnection != null && (responseCode = this.urlConnection.getResponseCode()) != this.expectedResponseCode) {
                try {
                    this.urlConnection.getInputStream().close();
                    throw new IOException(String.format("Expected response code: %d. Got: %d", this.expectedResponseCode, responseCode));
                }
                catch (IOException expected) {
                    InputStream errorStream = this.urlConnection.getErrorStream();
                    if (errorStream != null) {
                        String responseBody = FixJava.readReader((Reader)new InputStreamReader(errorStream, "UTF-8"));
                        String contentType = this.urlConnection.getHeaderField("Content-Type");
                        if (contentType == null) {
                            contentType = "text/plain";
                        }
                        throw new ResponseException(responseBody, expected, responseCode, contentType);
                    }
                    throw expected;
                }
            }
        }
        finally {
            this.out.close();
        }
    }

    public class ResponseException
    extends IOException {
        private final Gson gson;
        private final int responseCode;
        private final String contentType;

        public ResponseException(String responseBody, IOException cause, int responseCode, String contentType) {
            super(responseBody, cause);
            this.gson = new Gson();
            this.responseCode = responseCode;
            this.contentType = contentType;
        }

        @Override
        public String getMessage() {
            if (this.contentType.equals("application/json")) {
                Map map = (Map)this.gson.fromJson(super.getMessage(), Map.class);
                if (map.containsKey("error")) {
                    return this.getMessage0(map.get("error").toString());
                }
                return this.getMessage0(super.getMessage());
            }
            return this.getMessage0(super.getMessage());
        }

        private String getMessage0(String message) {
            return String.format("%s %s\nHTTP %d\n%s", URLOutputStream.this.method, URLOutputStream.this.url, this.responseCode, message);
        }
    }
}

