/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.perspectives.diagrams.SpringDiagramElementManager;
import com.intellij.spring.perspectives.diagrams.beans.SpringAppContextWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanClassWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationDiagramElementManager
extends SpringDiagramElementManager {
    public SpringIntegrationDiagramElementManager(@Nullable SmartPsiElementPointer<? extends PsiElement> pointer) {
        super(pointer);
    }

    public boolean isAcceptableAsNode(Object element) {
        if (element instanceof SpringAppContextWrapper) {
            SpringAppContextWrapper contextWrapper = (SpringAppContextWrapper)element;
            return SpringIntegrationDiagramElementManager.isSpringIntegrationContext(contextWrapper.getModule(), (PsiFile)contextWrapper.getWrapped()) && SpringIntegrationUtil.hasMessageChannels((CommonSpringModel)contextWrapper.getProcessingSpringModel(false));
        }
        if (element instanceof SpringBeanClassWrapper) {
            SpringBeanClassWrapper classWrapper = (SpringBeanClassWrapper)element;
            return SpringIntegrationDiagramElementManager.isSpringIntegrationContext(classWrapper.getModule(), ((PsiClass)classWrapper.getWrapped()).getContainingFile()) && SpringIntegrationUtil.hasMessageChannels((CommonSpringModel)classWrapper.getProcessingSpringModel(false));
        }
        return false;
    }

    private static boolean isSpringIntegrationContext(@Nullable Module module, @NotNull PsiFile wrapped) {
        if (wrapped == null) {
            SpringIntegrationDiagramElementManager.$$$reportNull$$$0(0);
        }
        return SpringIntegrationUtil.isSpringIntegrationUsed((Module)module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/intellij/spring/integration/diagram/SpringIntegrationDiagramElementManager", "isSpringIntegrationContext"));
    }
}

