/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.tree;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.struts.NamedDomModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.model.impl.DomModelFactory;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomFileElementNode;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiDomTreeStructure<T extends DomElement, M extends NamedDomModel<T>>
extends SimpleTreeStructure {
    private final Project myProject;
    private final DomModelFactory<T, M, PsiElement> myFactory;
    private final Map<Class, Boolean> myHiders;
    private final List<Class> myConsolidated;
    private final List<Class> myFolders;
    private final SimpleNode myRoot = new SimpleNode(){

        @NotNull
        public SimpleNode[] getChildren() {
            Module[] modules = ModuleManager.getInstance((Project)MultiDomTreeStructure.this.myProject).getModules();
            ArrayList<Module> webModules = new ArrayList<Module>();
            for (Module module : modules) {
                if (MultiDomTreeStructure.this.myFactory.getAllModels((UserDataHolder)module).size() <= 0) continue;
                webModules.add(module);
            }
            ArrayList<WebModuleNode> children = new ArrayList<WebModuleNode>(webModules.size());
            for (Module module : webModules) {
                children.add(new WebModuleNode(module));
            }
            SimpleNode[] simpleNodeArray = children.size() == 1 ? ((WebModuleNode)((Object)children.get(0))).getChildren() : children.toArray(new SimpleNode[0]);
            if (simpleNodeArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return simpleNodeArray;
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/tree/MultiDomTreeStructure$1", "getChildren"));
        }
    };

    public MultiDomTreeStructure(Project project, DomModelFactory<T, M, PsiElement> factory, Map<Class, Boolean> hiders, List<Class> consolidated, List<Class> folders) {
        this.myProject = project;
        this.myFactory = factory;
        this.myHiders = hiders;
        this.myConsolidated = consolidated;
        this.myFolders = folders;
    }

    @NotNull
    public Object getRootElement() {
        SimpleNode simpleNode = this.myRoot;
        if (simpleNode == null) {
            MultiDomTreeStructure.$$$reportNull$$$0(0);
        }
        return simpleNode;
    }

    @NotNull
    public List<DomFileElement<T>> getFileElements(M model) {
        List fileElements = this.myFactory.getFileElements(model);
        for (DomFileElement fileElement : fileElements) {
            fileElement.getFile().putUserData(BaseDomElementNode.TREE_NODES_HIDERS_KEY, this.myHiders);
            fileElement.getFile().putUserData(BaseDomElementNode.CONSOLIDATED_NODES_KEY, this.myConsolidated);
            fileElement.getFile().putUserData(BaseDomElementNode.FOLDER_NODES_KEY, this.myFolders);
        }
        List list = fileElements;
        if (list == null) {
            MultiDomTreeStructure.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected static SimpleNode createFileNode(DomFileElement fileElement) {
        return new FileElementNode(fileElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts/tree/MultiDomTreeStructure";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FileElementNode
    extends DomFileElementNode {
        FileElementNode(DomFileElement fileElement) {
            super(fileElement);
        }

        @Nullable
        public String getNodeName() {
            return this.getDomElement().getFile().getName();
        }

        public Icon getNodeIcon() {
            return this.getDomElement().getFile().getIcon(2);
        }
    }

    private static class ModelNode
    extends SimpleNode {
        private final M myModel;
        final /* synthetic */ MultiDomTreeStructure this$0;

        ModelNode(M model) {
            this.this$0 = var1_1;
            this.myModel = model;
            this.setUniformIcon(StrutsApiIcons.StrutsModule);
            this.setPlainText(model.getName());
        }

        @NotNull
        public SimpleNode[] getChildren() {
            List elements = this.this$0.getFileElements(this.myModel);
            SimpleNode[] children = new SimpleNode[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                children[i] = MultiDomTreeStructure.createFileNode(elements.get(i));
            }
            if (children == null) {
                ModelNode.$$$reportNull$$$0(0);
            }
            return children;
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/tree/MultiDomTreeStructure$ModelNode", "getChildren"));
        }
    }

    private class WebModuleNode
    extends SimpleNode {
        private final Module myModule;

        WebModuleNode(Module module) {
            this.myModule = module;
            this.setUniformIcon(JavaeeIcons.WEB_MODULE_SMALL);
            this.setPlainText(module.getName());
        }

        @NotNull
        public SimpleNode[] getChildren() {
            List models = MultiDomTreeStructure.this.myFactory.getAllModels((UserDataHolder)this.myModule);
            ArrayList<ModelNode> children = new ArrayList<ModelNode>(models.size());
            for (NamedDomModel model : models) {
                children.add(new ModelNode(MultiDomTreeStructure.this, model));
            }
            if (children.size() == 1) {
                SimpleNode[] simpleNodeArray = ((ModelNode)((Object)children.get(0))).getChildren();
                if (simpleNodeArray == null) {
                    WebModuleNode.$$$reportNull$$$0(0);
                }
                return simpleNodeArray;
            }
            SimpleNode[] simpleNodeArray = children.toArray(new SimpleNode[0]);
            if (simpleNodeArray == null) {
                WebModuleNode.$$$reportNull$$$0(1);
            }
            return simpleNodeArray;
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/tree/MultiDomTreeStructure$WebModuleNode", "getChildren"));
        }
    }
}

