/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting.syntax;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DomAnnotatorVisitor
implements DomElementVisitor {
    private final AnnotationHolder holder;

    protected DomAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public final void visitDomElement(DomElement element) {
        element.acceptChildren((DomElementVisitor)this);
    }

    protected final void checkRequiredAttribute(@NotNull GenericAttributeValue existing, @NotNull GenericAttributeValue required) {
        if (existing == null) {
            DomAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        if (required == null) {
            DomAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (existing.getXmlAttribute() != null && required.getXmlAttribute() == null) {
            Annotation annotation = this.holder.createErrorAnnotation((PsiElement)existing.getXmlAttribute(), '\'' + existing.getXmlElementName() + "' specified without '" + required.getXmlElementName() + '\'');
            if (!this.holder.isBatchMode()) {
                annotation.registerFix((IntentionAction)new InsertRequiredAttributeFix(existing.getXmlTag(), required.getXmlElementName(), new String[0]));
            }
        }
    }

    protected final void checkMutuallyExclusiveAttributes(GenericAttributeValue ... values) {
        if (values == null) {
            DomAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        int found = 0;
        for (GenericAttributeValue value : values) {
            if (value.getXmlAttribute() == null || ++found <= 1) continue;
            StringBuilder attributeNames = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                attributeNames.append(values[i].getXmlElementName());
                if (i >= values.length - 1) continue;
                attributeNames.append('|');
            }
            this.holder.createErrorAnnotation((PsiElement)value.ensureTagExists(), "Only one of " + attributeNames + " may be specified");
            return;
        }
    }

    protected final void checkDeprecatedAttribute(@NotNull GenericAttributeValue deprecatedAttribute, @NotNull GenericAttributeValue replacementAttribute, @Nullable String replacementValue) {
        if (deprecatedAttribute == null) {
            DomAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if (replacementAttribute == null) {
            DomAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (deprecatedAttribute.getXmlAttribute() != null) {
            Annotation annotation = this.holder.createWarningAnnotation((PsiElement)deprecatedAttribute.getXmlAttribute(), "Deprecated attribute " + deprecatedAttribute.getXmlElementName() + ", use " + replacementAttribute.getXmlElementName() + (replacementValue == null ? "" : "=\"" + replacementValue + "\"") + " instead");
            annotation.setTextAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
            if (replacementAttribute.getXmlAttribute() == null) {
                annotation.registerFix((IntentionAction)new ReplaceDeprecatedAttributeIntentionAction(deprecatedAttribute, replacementAttribute, replacementValue));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "required";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedAttribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementAttribute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRequiredAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMutuallyExclusiveAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeprecatedAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceDeprecatedAttributeIntentionAction
    extends BaseIntentionAction {
        private final GenericAttributeValue deprecatedAttribute;
        private final GenericAttributeValue replacementAttribute;
        private final String replacementValue;

        ReplaceDeprecatedAttributeIntentionAction(@NotNull GenericAttributeValue deprecatedAttribute, @NotNull GenericAttributeValue replacementAttribute, @Nullable String replacementValue) {
            if (deprecatedAttribute == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(0);
            }
            if (replacementAttribute == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(1);
            }
            this.deprecatedAttribute = deprecatedAttribute;
            this.replacementAttribute = replacementAttribute;
            this.replacementValue = replacementValue != null ? replacementValue : ((XmlAttribute)deprecatedAttribute.ensureXmlElementExists()).getValue();
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getText() {
            if ("Replace deprecated attribute" == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(3);
            }
            return "Replace deprecated attribute";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(4);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ReplaceDeprecatedAttributeIntentionAction.$$$reportNull$$$0(5);
            }
            XmlAttribute xmlAttribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute(this.replacementAttribute.getXmlElementName(), this.replacementValue);
            this.deprecatedAttribute.ensureXmlElementExists().replace((PsiElement)xmlAttribute);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deprecatedAttribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacementAttribute";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

