/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.diagram;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.struts.diagram.StrutsGraphComponent;
import com.intellij.struts.diagram.StrutsGraphDataModel;
import com.intellij.struts.diagram.StrutsObject;
import com.intellij.struts.diagram.StrutsPresentationModel;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsGraphEditor
extends PerspectiveFileEditor {
    private StrutsGraphComponent myComponent;
    private final StrutsConfig myStrutsConfig;

    protected StrutsGraphEditor(Project project, VirtualFile file, StrutsConfig strutsConfig) {
        super(project, file);
        this.myStrutsConfig = strutsConfig;
    }

    private void initialize(Project project) {
        final Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        final StrutsGraphDataModel dataModel = new StrutsGraphDataModel(this.myStrutsConfig);
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        StrutsPresentationModel presentationModel = new StrutsPresentationModel(project, (ModificationTracker)this.myStrutsConfig.getManager(), dataModel, (Graph)graph);
        presentationModel.setShowEdgeLabels(true);
        final GraphBuilder graphBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)dataModel, (GraphPresentationModel)presentationModel);
        this.myComponent = new StrutsGraphComponent(project, (GraphBuilder<StrutsObject, StrutsObject>)graphBuilder);
        DataProvider dataProvider = new DataProvider(){

            @NonNls
            @Nullable
            public Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    PsiElement psiElement;
                    StrutsObject nodeObject;
                    Node node;
                    NodeCursor nodeCursor = graph.selectedNodes();
                    if (nodeCursor != null && nodeCursor.size() > 0 && (node = nodeCursor.node()) != null && (nodeObject = (StrutsObject)graphBuilder.getNodeObject(node)) != null && (psiElement = nodeObject.getPsiElement()) instanceof Navigatable) {
                        return psiElement;
                    }
                } else if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return "reference.struts.webflow";
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/struts/diagram/StrutsGraphEditor$1", "getData"));
            }
        };
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)dataProvider);
        this.myStrutsConfig.getManager().addDomEventListener(new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                dataModel.setDirty();
                graphBuilder.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/struts/diagram/StrutsGraphEditor$2", "eventOccured"));
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
    }

    protected DomElement getSelectedDomElement() {
        return null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
    }

    @NotNull
    protected JComponent createCustomComponent() {
        if (this.myComponent == null) {
            this.initialize(this.getProject());
        }
        JComponent jComponent = this.myComponent.getComponent();
        if (jComponent == null) {
            StrutsGraphEditor.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myComponent.getBuilder().getView().getCanvasComponent();
    }

    @NonNls
    @NotNull
    public String getName() {
        if ("Web Flow Diagram" == null) {
            StrutsGraphEditor.$$$reportNull$$$0(1);
        }
        return "Web Flow Diagram";
    }

    public void commit() {
    }

    public void reset() {
        this.myComponent.getBuilder().updateGraph();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts/diagram/StrutsGraphEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

