/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.CreateFrameworkInstanceDialog;
import org.osmorc.settings.FrameworkDefinitionListener;
import org.osmorc.util.OsgiUiUtil;

public class FrameworkDefinitionsEditorComponent {
    private JPanel myMainPanel;
    private JPanel myFrameworkInstancesPanel;
    private final JBList myFrameworkInstances;
    private JLabel myFrameworkIntegrator;
    private JLabel myHomeDir;
    private JLabel myFrameworkInstanceName;
    private JLabel myVersion;
    private final DefaultListModel<FrameworkInstanceDefinition> myModel;
    private final MessageBus myBus;
    private final List<Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition>> myModified;

    public FrameworkDefinitionsEditorComponent() {
        this.$$$setupUI$$$();
        this.myModel = new DefaultListModel();
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        this.myModified = ContainerUtil.newArrayList();
        this.myFrameworkInstances = new JBList(this.myModel);
        this.myFrameworkInstances.getEmptyText().setText(OsmorcBundle.message("frameworks.empty", new Object[0]));
        this.myFrameworkInstances.setCellRenderer((ListCellRenderer)((Object)new OsgiUiUtil.FrameworkInstanceRenderer()));
        List addActions = FrameworkIntegratorRegistry.getInstance().getFrameworkIntegrators().stream().map(x$0 -> new AddAction((FrameworkIntegrator)x$0)).sorted().collect(Collectors.toList());
        this.myFrameworkInstancesPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myFrameworkInstances).setAddAction(b -> JBPopupFactory.getInstance().createActionGroupPopup(OsmorcBundle.message("frameworks.add.title", new Object[0]), (ActionGroup)new DefaultActionGroup(addActions), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), false, false, false, null, -1, null).show((RelativePoint)ObjectUtils.notNull((Object)b.getPreferredPopupPoint()))).setRemoveAction(b -> this.removeFrameworkInstance()).setEditAction(b -> this.editFrameworkInstance()).createPanel(), "Center");
        this.myFrameworkInstances.addListSelectionListener(e -> {
            int index = this.myFrameworkInstances.getSelectedIndex();
            if (index != -1) {
                FrameworkInstanceDefinition instance = this.myModel.get(index);
                this.myFrameworkIntegrator.setText(instance.getFrameworkIntegratorName());
                this.myHomeDir.setText(instance.getBaseFolder());
                this.myVersion.setText((String)ObjectUtils.notNull((Object)instance.getVersion(), (Object)""));
                this.myFrameworkInstanceName.setText(instance.getName());
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (FrameworkDefinitionsEditorComponent.this.myFrameworkInstances.getSelectedIndex() != -1) {
                    FrameworkDefinitionsEditorComponent.this.editFrameworkInstance();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myFrameworkInstances);
    }

    private void addFrameworkInstance(FrameworkIntegrator integrator) {
        FrameworkInstanceDefinition instance = new FrameworkInstanceDefinition();
        instance.setFrameworkIntegratorName(integrator.getDisplayName());
        CreateFrameworkInstanceDialog dialog = new CreateFrameworkInstanceDialog(instance, this.myModel);
        dialog.pack();
        if (dialog.showAndGet()) {
            instance = dialog.createDefinition();
            this.myModel.addElement(instance);
            this.myFrameworkInstances.setSelectedIndex(this.myModel.getSize() - 1);
            this.myModified.add((Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition>)Pair.create(null, (Object)((Object)instance)));
        }
    }

    private void removeFrameworkInstance() {
        int index = this.myFrameworkInstances.getSelectedIndex();
        if (index != -1) {
            FrameworkInstanceDefinition instance = this.myModel.get(index);
            this.myModel.remove(index);
            this.myFrameworkInstances.setSelectedIndex(0);
            this.myModified.add((Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition>)Pair.create((Object)((Object)instance), null));
        }
    }

    private void editFrameworkInstance() {
        int index = this.myFrameworkInstances.getSelectedIndex();
        if (index != -1) {
            FrameworkInstanceDefinition instance = this.myModel.get(index);
            CreateFrameworkInstanceDialog dialog = new CreateFrameworkInstanceDialog(instance, this.myModel);
            dialog.pack();
            if (dialog.showAndGet()) {
                FrameworkInstanceDefinition newInstance = dialog.createDefinition();
                this.myModel.set(index, newInstance);
                this.myModified.add((Pair<FrameworkInstanceDefinition, FrameworkInstanceDefinition>)Pair.create((Object)((Object)instance), (Object)((Object)newInstance)));
            }
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void resetTo(@NotNull ApplicationSettings settings) {
        if (settings == null) {
            FrameworkDefinitionsEditorComponent.$$$reportNull$$$0(0);
        }
        this.myModel.clear();
        for (FrameworkInstanceDefinition instance : settings.getActiveFrameworkInstanceDefinitions()) {
            this.myModel.addElement(instance);
        }
        this.myModified.clear();
    }

    public void applyTo(@NotNull ApplicationSettings settings) {
        if (settings == null) {
            FrameworkDefinitionsEditorComponent.$$$reportNull$$$0(1);
        }
        int instances = this.myModel.getSize();
        ArrayList<FrameworkInstanceDefinition> definitions = new ArrayList<FrameworkInstanceDefinition>(instances);
        for (int i = 0; i < instances; ++i) {
            definitions.add(this.myModel.get(i));
        }
        settings.setFrameworkInstanceDefinitions(definitions);
        ((FrameworkDefinitionListener)this.myBus.syncPublisher(FrameworkDefinitionListener.TOPIC)).definitionsChanged(this.myModified);
        this.myModified.clear();
    }

    public boolean isModified() {
        return !this.myModified.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "org/osmorc/settings/FrameworkDefinitionsEditorComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Framework Instances", (int)0, (int)0, null, null));
        this.myFrameworkInstancesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Type:");
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFrameworkIntegrator = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Home directory:");
        jPanel4.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHomeDir = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Name:");
        jPanel4.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFrameworkInstanceName = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Version:");
        jPanel4.add((Component)jLabel8, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVersion = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel5.setLabelFor(jLabel4);
        jLabel7.setLabelFor(jLabel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class AddAction
    extends AnAction
    implements DumbAware,
    Comparable<AddAction> {
        private final FrameworkIntegrator myIntegrator;

        private AddAction(FrameworkIntegrator integrator) {
            super(integrator.getDisplayName());
            this.myIntegrator = integrator;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            FrameworkDefinitionsEditorComponent.this.addFrameworkInstance(this.myIntegrator);
        }

        @Override
        public int compareTo(@NotNull AddAction o) {
            if (o == null) {
                AddAction.$$$reportNull$$$0(1);
            }
            return this.myIntegrator.getDisplayName().compareTo(o.myIntegrator.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "org/osmorc/settings/FrameworkDefinitionsEditorComponent$AddAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

