/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkInstanceManager;
import org.osmorc.i18n.OsmorcBundle;

public class CreateFrameworkInstanceDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myBaseFolderChooser;
    private JTextField myNameField;
    private JBLabel myVersionLabel;
    private final FrameworkInstanceDefinition myInstance;
    private final DefaultListModel myModel;
    private final FrameworkIntegrator myIntegrator;

    public CreateFrameworkInstanceDialog(@NotNull FrameworkInstanceDefinition instance, @NotNull DefaultListModel model) {
        if (instance == null) {
            CreateFrameworkInstanceDialog.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CreateFrameworkInstanceDialog.$$$reportNull$$$0(1);
        }
        super(true);
        this.myInstance = instance;
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myIntegrator = FrameworkIntegratorRegistry.getInstance().findIntegratorByInstanceDefinition(instance);
        assert (this.myIntegrator != null) : instance;
        this.setTitle(OsmorcBundle.message("framework.edit.title", this.myIntegrator.getDisplayName()));
        this.setModal(true);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        String title = OsmorcBundle.message("framework.path.chooser.title", new Object[0]);
        String description = OsmorcBundle.message("framework.path.chooser.description", this.myIntegrator.getDisplayName());
        this.myBaseFolderChooser.addBrowseFolderListener(title, description, null, descriptor);
        this.myBaseFolderChooser.getTextField().setEditable(false);
        this.myBaseFolderChooser.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CreateFrameworkInstanceDialog.this.checkInstance();
                CreateFrameworkInstanceDialog.this.updateVersion();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/osmorc/settings/CreateFrameworkInstanceDialog$1", "textChanged"));
            }
        });
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CreateFrameworkInstanceDialog.this.checkInstance();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/osmorc/settings/CreateFrameworkInstanceDialog$2", "textChanged"));
            }
        });
        this.myBaseFolderChooser.setText((String)ObjectUtils.notNull((Object)instance.getBaseFolder(), (Object)""));
        this.myNameField.setText((String)ObjectUtils.notNull((Object)instance.getName(), (Object)""));
        this.myVersionLabel.setText((String)ObjectUtils.notNull((Object)instance.getVersion(), (Object)""));
        this.init();
        this.checkInstance();
    }

    private void checkInstance() {
        FrameworkInstanceDefinition newInstance = this.createDefinition();
        String message = this.myIntegrator.getFrameworkInstanceManager().checkValidity(newInstance);
        if (message == null) {
            for (int i = 0; i < this.myModel.size(); ++i) {
                FrameworkInstanceDefinition instance = (FrameworkInstanceDefinition)((Object)this.myModel.get(i));
                if (!newInstance.equals((Object)instance) || instance == this.myInstance) continue;
                message = OsmorcBundle.message("framework.name.duplicate", new Object[0]);
            }
        }
        this.setErrorText(message);
        this.setOKActionEnabled(message == null);
    }

    private void updateVersion() {
        String version = null;
        FrameworkInstanceManager manager = this.myIntegrator.getFrameworkInstanceManager();
        if (manager instanceof AbstractFrameworkInstanceManager) {
            version = ((AbstractFrameworkInstanceManager)manager).getVersion(this.createDefinition());
        }
        this.myVersionLabel.setText((String)ObjectUtils.notNull(version, (Object)""));
        if (StringUtil.isEmptyOrSpaces((String)this.myNameField.getText())) {
            String name = this.myIntegrator.getDisplayName();
            if (version != null) {
                name = name + " (" + version + ")";
            }
            this.myNameField.setText(name);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBaseFolderChooser.getButton();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected String getHelpId() {
        return "reference.settings.project.osgi.new.framework.instance";
    }

    @NotNull
    public FrameworkInstanceDefinition createDefinition() {
        FrameworkInstanceDefinition framework = new FrameworkInstanceDefinition();
        framework.setName(this.myNameField.getText().trim());
        framework.setFrameworkIntegratorName(this.myIntegrator.getDisplayName());
        framework.setBaseFolder(this.myBaseFolderChooser.getText().trim());
        framework.setVersion(this.myVersionLabel.getText().trim());
        FrameworkInstanceDefinition frameworkInstanceDefinition = framework;
        if (frameworkInstanceDefinition == null) {
            CreateFrameworkInstanceDialog.$$$reportNull$$$0(2);
        }
        return frameworkInstanceDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/settings/CreateFrameworkInstanceDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/settings/CreateFrameworkInstanceDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 10));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Home directory:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myBaseFolderChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(40);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Version:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

