/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiRunConfigurationChecker;
import org.osmorc.run.OsgiRunState;
import org.osmorc.run.ui.OsgiRunConfigurationEditor;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ProjectSettings;

public class OsgiRunConfiguration
extends RunConfigurationBase
implements ModuleRunConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"#org.osmorc.run.OsgiRunConfiguration");
    private static final String BUNDLE_ELEMENT = "bundle";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VM_PARAMETERS_ATTRIBUTE = "vmParameters";
    private static final String PROGRAM_PARAMETERS_ATTRIBUTE = "programParameters";
    private static final String WORKING_DIR_ATTRIBUTE = "workingDir";
    private static final String FRAMEWORK_ELEMENT = "framework";
    private static final String INSTANCE_ATTRIBUTE = "instance";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ADDITIONAL_PROPERTIES_ELEMENT = "additionalProperties";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String START_AFTER_INSTALLATION_ATTRIBUTE = "startAfterInstallation";
    private static final String START_LEVEL_ATTRIBUTE = "startLevel";
    private static final String INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE = "includeAllBundlesInClassPath";
    private static final String USE_ALTERNATIVE_JRE_ATTRIBUTE = "useAlternativeJre";
    private static final String ALTERNATIVE_JRE_PATH = "alternativeJrePath";
    private static final String FRAMEWORK_START_LEVEL = "frameworkStartLevel";
    private static final String DEFAULT_START_LEVEL = "defaultStartLevel";
    private static final String GENERATE_WORKING_DIR_ATTRIBUTE = "generateWorkingDir";
    private OsgiRunConfigurationChecker checker;
    private List<SelectedBundle> bundlesToDeploy = new ArrayList<SelectedBundle>();
    private int frameworkStartLevel = 1;
    private int defaultStartLevel = 5;
    private String programParameters;
    private String vmParameters;
    private String alternativeJrePath;
    private boolean useAlternativeJre;
    private FrameworkInstanceDefinition instanceToUse;
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private boolean includeAllBundlesInClassPath;
    private String workingDir;
    private boolean generateWorkingDir;

    public OsgiRunConfiguration(Project project, ConfigurationFactory configurationFactory, String name) {
        super(project, configurationFactory, name);
        GenericRunProperties.setStartConsole(this.additionalProperties, true);
    }

    @Nullable
    public RunConfiguration clone() {
        OsgiRunConfiguration conf = (OsgiRunConfiguration)super.clone();
        if (conf == null) {
            return null;
        }
        conf.bundlesToDeploy = new ArrayList<SelectedBundle>(this.bundlesToDeploy);
        conf.additionalProperties = new HashMap<String, String>(this.additionalProperties);
        return conf;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element additionalProperties;
        String name;
        if (element == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(0);
        }
        this.workingDir = element.getAttributeValue(WORKING_DIR_ATTRIBUTE);
        this.vmParameters = element.getAttributeValue(VM_PARAMETERS_ATTRIBUTE);
        this.programParameters = element.getAttributeValue(PROGRAM_PARAMETERS_ATTRIBUTE);
        this.includeAllBundlesInClassPath = Boolean.valueOf(element.getAttributeValue(INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE, "false"));
        this.useAlternativeJre = Boolean.valueOf(element.getAttributeValue(USE_ALTERNATIVE_JRE_ATTRIBUTE, "false"));
        this.alternativeJrePath = element.getAttributeValue(ALTERNATIVE_JRE_PATH, "");
        this.generateWorkingDir = Boolean.valueOf(element.getAttributeValue(GENERATE_WORKING_DIR_ATTRIBUTE));
        try {
            this.frameworkStartLevel = Integer.parseInt(element.getAttributeValue(FRAMEWORK_START_LEVEL, "1"));
        }
        catch (NumberFormatException e) {
            this.frameworkStartLevel = 1;
        }
        try {
            this.defaultStartLevel = Integer.parseInt(element.getAttributeValue(DEFAULT_START_LEVEL, "5"));
        }
        catch (NumberFormatException e) {
            this.defaultStartLevel = 5;
        }
        List children = element.getChildren(BUNDLE_ELEMENT);
        this.bundlesToDeploy.clear();
        for (Element child : children) {
            String startAfterInstallationString;
            SelectedBundle.BundleType type;
            String name2 = child.getAttributeValue(NAME_ATTRIBUTE);
            String url = child.getAttributeValue(URL_ATTRIBUTE);
            String startLevel = child.getAttributeValue(START_LEVEL_ATTRIBUTE);
            String typeName = child.getAttributeValue(TYPE_ATTRIBUTE);
            try {
                type = SelectedBundle.BundleType.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                LOG.error("unexpected bundle type '" + typeName + "'");
                type = SelectedBundle.BundleType.Module;
            }
            String path = url != null ? VfsUtilCore.urlToPath((String)url) : null;
            SelectedBundle selectedBundle = new SelectedBundle(type, name2, path);
            if (startLevel != null) {
                try {
                    selectedBundle.setStartLevel(Integer.parseInt(startLevel));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((startAfterInstallationString = child.getAttributeValue(START_AFTER_INSTALLATION_ATTRIBUTE)) != null) {
                selectedBundle.setStartAfterInstallation(Boolean.parseBoolean(startAfterInstallationString));
            }
            this.bundlesToDeploy.add(selectedBundle);
        }
        Element framework = element.getChild(FRAMEWORK_ELEMENT);
        if (framework != null && (name = framework.getAttributeValue(INSTANCE_ATTRIBUTE)) != null) {
            ApplicationSettings settings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
            this.instanceToUse = settings.getFrameworkInstance(name);
        }
        if ((additionalProperties = element.getChild(ADDITIONAL_PROPERTIES_ELEMENT)) == null) {
            additionalProperties = element.getChild("additinalProperties");
        }
        if (additionalProperties != null) {
            List attributes = additionalProperties.getAttributes();
            for (Attribute attribute : attributes) {
                this.additionalProperties.put(attribute.getName(), attribute.getValue());
            }
        }
        super.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(1);
        }
        element.setAttribute(VM_PARAMETERS_ATTRIBUTE, this.vmParameters == null ? "" : this.vmParameters);
        element.setAttribute(PROGRAM_PARAMETERS_ATTRIBUTE, this.programParameters == null ? "" : this.programParameters);
        element.setAttribute(INCLUDE_ALL_BUNDLES_IN_CLASS_PATH_ATTRIBUTE, Boolean.toString(this.includeAllBundlesInClassPath));
        element.setAttribute(WORKING_DIR_ATTRIBUTE, this.workingDir == null ? "" : this.workingDir);
        element.setAttribute(USE_ALTERNATIVE_JRE_ATTRIBUTE, String.valueOf(this.useAlternativeJre));
        element.setAttribute(ALTERNATIVE_JRE_PATH, this.alternativeJrePath != null ? this.alternativeJrePath : "");
        element.setAttribute(FRAMEWORK_START_LEVEL, String.valueOf(this.frameworkStartLevel));
        element.setAttribute(DEFAULT_START_LEVEL, String.valueOf(this.defaultStartLevel));
        element.setAttribute(GENERATE_WORKING_DIR_ATTRIBUTE, String.valueOf(this.generateWorkingDir));
        for (SelectedBundle selectedBundle : this.bundlesToDeploy) {
            String path;
            Element bundle = new Element(BUNDLE_ELEMENT);
            bundle.setAttribute(NAME_ATTRIBUTE, selectedBundle.getName());
            if (!selectedBundle.isModule() && (path = selectedBundle.getBundlePath()) != null) {
                bundle.setAttribute(URL_ATTRIBUTE, VfsUtilCore.pathToUrl((String)path));
            }
            bundle.setAttribute(START_LEVEL_ATTRIBUTE, String.valueOf(selectedBundle.getStartLevel()));
            bundle.setAttribute(TYPE_ATTRIBUTE, selectedBundle.getBundleType().name());
            bundle.setAttribute(START_AFTER_INSTALLATION_ATTRIBUTE, Boolean.toString(selectedBundle.isStartAfterInstallation()));
            element.addContent(bundle);
        }
        Element framework = new Element(FRAMEWORK_ELEMENT);
        framework.setAttribute(INSTANCE_ATTRIBUTE, this.instanceToUse != null ? this.instanceToUse.getName() : "");
        element.addContent(framework);
        Element additionalProperties = new Element(ADDITIONAL_PROPERTIES_ELEMENT);
        for (String additionalPropertyName : this.additionalProperties.keySet()) {
            additionalProperties.setAttribute(additionalPropertyName, this.additionalProperties.get(additionalPropertyName));
        }
        element.addContent(additionalProperties);
        super.writeExternal(element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        OsgiRunConfigurationEditor osgiRunConfigurationEditor = new OsgiRunConfigurationEditor(this.getProject());
        if (osgiRunConfigurationEditor == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(2);
        }
        return osgiRunConfigurationEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(4);
        }
        return new OsgiRunState(env, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getInstanceToUse() == null) {
            throw new RuntimeConfigurationError(OsmorcBundle.message("run.configuration.no.instance", new Object[0]));
        }
        if (this.isUseAlternativeJre()) {
            JavaParametersUtil.checkAlternativeJRE((String)this.getAlternativeJrePath());
        }
        if (this.checker != null) {
            this.checker.checkConfiguration(this);
        }
    }

    @NotNull
    public Module[] getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.getProject());
        for (SelectedBundle selectedBundle : this.getBundlesToDeploy()) {
            if (!selectedBundle.isModule()) continue;
            Module module = moduleManager.findModuleByName(selectedBundle.getName());
            if (module != null) {
                modules.add(module);
                continue;
            }
            LOG.error("no module [" + selectedBundle.getName() + "]");
        }
        Module[] moduleArray = modules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(5);
        }
        return moduleArray;
    }

    @NotNull
    public Map<String, String> getAdditionalProperties() {
        Map<String, String> map = Collections.unmodifiableMap(this.additionalProperties);
        if (map == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(6);
        }
        return map;
    }

    public String getAlternativeJrePath() {
        return this.alternativeJrePath;
    }

    @NotNull
    public List<SelectedBundle> getBundlesToDeploy() {
        List<SelectedBundle> list = this.bundlesToDeploy;
        if (list == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(7);
        }
        return list;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkStartLevel;
    }

    @Nullable
    public FrameworkInstanceDefinition getInstanceToUse() {
        if (this.instanceToUse != null) {
            return this.instanceToUse;
        }
        String projectInstanceName = ProjectSettings.getInstance(this.getProject()).getFrameworkInstanceName();
        FrameworkInstanceDefinition projectInstance = ApplicationSettings.getInstance().getFrameworkInstance(projectInstanceName);
        if (projectInstance != null) {
            return projectInstance;
        }
        return null;
    }

    public String getProgramParameters() {
        return this.programParameters != null ? this.programParameters : "";
    }

    @NotNull
    public String getVmParameters() {
        String string = this.vmParameters != null ? this.vmParameters : "";
        if (string == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getWorkingDir() {
        return this.workingDir != null ? this.workingDir : "";
    }

    public boolean isAutoStartLevel() {
        return this.frameworkStartLevel == 0;
    }

    public boolean isIncludeAllBundlesInClassPath() {
        return this.includeAllBundlesInClassPath;
    }

    public boolean isUseAlternativeJre() {
        return this.useAlternativeJre;
    }

    public void putAdditionalProperties(@NotNull Map<String, String> props) {
        if (props == null) {
            OsgiRunConfiguration.$$$reportNull$$$0(9);
        }
        this.additionalProperties.putAll(props);
    }

    public void setAdditionalChecker(@Nullable OsgiRunConfigurationChecker checker) {
        this.checker = checker;
    }

    public void setAlternativeJrePath(String alternativeJrePath) {
        this.alternativeJrePath = alternativeJrePath;
    }

    public void setBundlesToDeploy(List<SelectedBundle> bundlesToDeploy) {
        this.bundlesToDeploy = bundlesToDeploy;
    }

    public void setFrameworkStartLevel(int frameworkStartLevel) {
        this.frameworkStartLevel = frameworkStartLevel;
    }

    public void setIncludeAllBundlesInClassPath(boolean includeAllBundlesInClassPath) {
        this.includeAllBundlesInClassPath = includeAllBundlesInClassPath;
    }

    public void setInstanceToUse(@Nullable FrameworkInstanceDefinition instanceToUse) {
        this.instanceToUse = instanceToUse;
    }

    public void setProgramParameters(String programParameters) {
        this.programParameters = programParameters;
    }

    public void setUseAlternativeJre(boolean useAlternativeJre) {
        this.useAlternativeJre = useAlternativeJre;
    }

    public void setVmParameters(String vmParameters) {
        this.vmParameters = vmParameters;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public int getDefaultStartLevel() {
        return this.defaultStartLevel;
    }

    public void setDefaultStartLevel(int defaultStartLevel) {
        this.defaultStartLevel = defaultStartLevel;
    }

    public boolean isGenerateWorkingDir() {
        return this.generateWorkingDir;
    }

    public void setGenerateWorkingDir(boolean generateWorkingDir) {
        this.generateWorkingDir = generateWorkingDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/run/OsgiRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/run/OsgiRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlesToDeploy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAdditionalProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

