/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.obrimport.springsource;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.Obr;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class SpringSourceObr
implements Obr {
    private static final Pattern RESULT_PARSING_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\"[^>]*>([^<]+)");
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("&lt;groupId&gt;(.*?)&lt;/groupId&gt;");
    private static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("&lt;artifactId&gt;(.*?)&lt;/artifactId&gt;");
    private static final Pattern VERSION_PATTERN = Pattern.compile("&lt;version&gt;(.*?)&lt;/version&gt;");
    private static final Pattern CLASSIFIER_PATTERN = Pattern.compile("&lt;classifier&gt;(.*?)&lt;/classifier&gt;");
    private static final MavenRepository[] SPRINGSOURCE_REPOS = new MavenRepository[]{new MavenRepository("repository.springsource.com.release", "SpringSource OBR - Release", "http://repository.springsource.com/maven/bundles/release"), new MavenRepository("repository.springsource.com.external", "SpringSource OBR - External", "http://repository.springsource.com/maven/bundles/external")};

    @Override
    public String getDisplayName() {
        return "Springsource Enterprise Bundle Repository";
    }

    @Override
    public boolean supportsMaven() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ObrMavenResult[] queryForMavenArtifact(@NotNull String queryString, @NotNull ProgressIndicator indicator) throws IOException {
        ObrMavenResult[] obrMavenResultArray;
        block10: {
            if (queryString == null) {
                SpringSourceObr.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                SpringSourceObr.$$$reportNull$$$0(1);
            }
            try {
                ArrayList<ObrMavenResult> result = new ArrayList<ObrMavenResult>();
                indicator.setText("Connecting to " + this.getDisplayName() + "...");
                String url = "http://www.springsource.com/repository/app/search?query=" + URLEncoder.encode(queryString, "utf-8");
                String contents = HttpRequests.request((String)url).readString(indicator);
                indicator.setText("Search completed. Getting results.");
                indicator.checkCanceled();
                int start = contents.indexOf("<div id=\"results-fragment\">");
                int end = contents.indexOf("</div>", start);
                contents = contents.substring(start, end);
                Matcher m = RESULT_PARSING_PATTERN.matcher(contents);
                while (m.find()) {
                    String detailUrl = m.group(1);
                    detailUrl = detailUrl.replaceAll(";jsessionid.*?\\?", "?");
                    detailUrl = detailUrl.replace("&amp;", "&");
                    String packageName = m.group(2);
                    indicator.setText("Loading details for result " + packageName + "...");
                    String detail = HttpRequests.request((String)("http://www.springsource.com" + detailUrl)).readString(indicator);
                    indicator.checkCanceled();
                    indicator.setText("Details retrieved. Getting detail information...");
                    String classifier = null;
                    Matcher groupMatcher = GROUP_ID_PATTERN.matcher(detail);
                    if (!groupMatcher.find()) continue;
                    String groupId = groupMatcher.group(1);
                    Matcher artifactMatcher = ARTIFACT_ID_PATTERN.matcher(detail);
                    if (!artifactMatcher.find()) continue;
                    String artifactId = artifactMatcher.group(1);
                    Matcher versionMatcher = VERSION_PATTERN.matcher(detail);
                    if (!versionMatcher.find()) continue;
                    String version = versionMatcher.group(1);
                    Matcher classifierMatcher = CLASSIFIER_PATTERN.matcher(detail);
                    if (classifierMatcher.find()) {
                        classifier = classifierMatcher.group(1);
                    }
                    result.add(new ObrMavenResult(groupId, artifactId, version, classifier, this));
                }
                indicator.setText("Done. " + result.size() + " artifacts found.");
                obrMavenResultArray = result.toArray(new ObrMavenResult[0]);
                if (obrMavenResultArray != null) break block10;
            }
            catch (ProcessCanceledException ignored) {
                indicator.setText("Canceled.");
                ObrMavenResult[] obrMavenResultArray2 = new ObrMavenResult[]{};
                if (obrMavenResultArray2 == null) {
                    SpringSourceObr.$$$reportNull$$$0(3);
                }
                return obrMavenResultArray2;
            }
            finally {
                indicator.setIndeterminate(false);
            }
            SpringSourceObr.$$$reportNull$$$0(2);
        }
        return obrMavenResultArray;
    }

    @Override
    @NotNull
    public MavenRepository[] getMavenRepositories() {
        if (SPRINGSOURCE_REPOS == null) {
            SpringSourceObr.$$$reportNull$$$0(4);
        }
        return SPRINGSOURCE_REPOS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/obrimport/springsource/SpringSourceObr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/obrimport/springsource/SpringSourceObr";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "queryForMavenArtifact";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryForMavenArtifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

