/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.ObrSearchDialog;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class NonOsgiMavenDependencyInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        boolean isMaven;
        if (problemsHolder == null) {
            NonOsgiMavenDependencyInspection.$$$reportNull$$$0(0);
        }
        Object object = !(isMaven = MavenDomUtil.isMavenFile((PsiFile)problemsHolder.getFile())) ? PsiElementVisitor.EMPTY_VISITOR : new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String version;
                String artifactId;
                String groupId;
                File repo;
                File artifactFile;
                String scope;
                MavenDomDependency dependency;
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)tag) && (dependency = NonOsgiMavenDependencyInspection.getDependency(tag)) != null && !"test".equals(scope = dependency.getScope().getStringValue()) && (artifactFile = MavenArtifactUtil.getArtifactFile((File)(repo = MavenProjectsManager.getInstance((Project)tag.getProject()).getLocalRepository()), (String)(groupId = dependency.getGroupId().getStringValue()), (String)(artifactId = dependency.getArtifactId().getStringValue()), (String)(version = dependency.getVersion().getStringValue()), (String)"jar")).exists() && !CachingBundleInfoProvider.isBundle((String)artifactFile.getPath())) {
                    problemsHolder.registerProblem((PsiElement)tag, OsmorcBundle.message("NonOsgiMavenDependencyInspection.message", new Object[0]), new LocalQuickFix[]{new FindOsgiCapableMavenDependencyQuickFix()});
                }
            }
        };
        if (object == null) {
            NonOsgiMavenDependencyInspection.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static MavenDomDependency getDependency(XmlTag tag) {
        DomElement dom;
        PsiElement grand;
        PsiElement parent;
        if (!(!"dependency".equals(tag.getName()) || (parent = tag.getParent()) == null || (grand = parent.getParent()) instanceof XmlTag && "plugin".equals(((XmlTag)grand).getName()) || (dom = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) == null)) {
            return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FindOsgiCapableMavenDependencyQuickFix
    extends AbstractOsgiQuickFix {
        private FindOsgiCapableMavenDependencyQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("NonOsgiMavenDependencyInspection.fix", new Object[0]);
            if (string == null) {
                FindOsgiCapableMavenDependencyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            MavenDomDependency dependency;
            if (project == null) {
                FindOsgiCapableMavenDependencyQuickFix.$$$reportNull$$$0(1);
            }
            if (problemDescriptor == null) {
                FindOsgiCapableMavenDependencyQuickFix.$$$reportNull$$$0(2);
            }
            if ((dependency = NonOsgiMavenDependencyInspection.getDependency((XmlTag)problemDescriptor.getPsiElement())) == null) {
                return;
            }
            ObrMavenResult result = ObrSearchDialog.queryForMavenArtifact(project, dependency.getArtifactId().toString());
            if (result == null) {
                return;
            }
            PsiFile psiFile = problemDescriptor.getPsiElement().getContainingFile();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
                MavenDomProjectModel model;
                if (project == null) {
                    FindOsgiCapableMavenDependencyQuickFix.$$$reportNull$$$0(3);
                }
                if ((model = MavenDomUtil.getMavenDomProjectModel((Project)project, (VirtualFile)psiFile.getVirtualFile())) == null) {
                    return;
                }
                MavenDomDependency dummy = model.getDependencies().addDependency();
                dummy.getGroupId().setStringValue(result.getGroupId());
                dummy.getArtifactId().setStringValue(result.getArtifactId());
                dummy.getVersion().setStringValue(result.getVersion());
                String scope = dependency.getScope().getStringValue();
                if (!StringUtil.isEmpty((String)scope)) {
                    dummy.getScope().setStringValue(scope);
                }
                XmlElement newDep = dummy.getXmlElement();
                XmlElement oldDep = dependency.getXmlElement();
                assert (newDep != null) : dummy;
                assert (oldDep != null) : dependency;
                oldDep.replace(newDep.copy());
                newDep.delete();
                Set projectRepositoryUrls = ContainerUtil.map2Set((Collection)model.getRepositories().getRepositories(), repository -> repository.getUrl().getStringValue());
                List newRepositories = ContainerUtil.newSmartList((Object[])result.getBundleRepository().getMavenRepositories());
                Iterator i = newRepositories.iterator();
                while (i.hasNext()) {
                    MavenRepository repository2 = (MavenRepository)i.next();
                    if (!projectRepositoryUrls.contains(repository2.getRepositoryUrl())) continue;
                    i.remove();
                }
                for (MavenRepository repository2 : newRepositories) {
                    MavenDomRepository added = model.getRepositories().addRepository();
                    added.getId().setStringValue(repository2.getRepositoryId());
                    added.getUrl().setStringValue(repository2.getRepositoryUrl());
                    added.getName().setStringValue(repository2.getRepositoryDescription());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

