/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osgi.framework.Version;

public class BundleVersionParser
extends StandardHeaderParser {
    public static final HeaderParser INSTANCE = new BundleVersionParser();

    private BundleVersionParser() {
    }

    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        HeaderValue value;
        if (header == null) {
            BundleVersionParser.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            BundleVersionParser.$$$reportNull$$$0(1);
        }
        if ((value = header.getHeaderValue()) instanceof HeaderValuePart) {
            try {
                new Version(value.getUnwrappedText());
            }
            catch (IllegalArgumentException e) {
                TextRange range = ((HeaderValuePart)value).getHighlightingRange();
                holder.createErrorAnnotation(range, e.getMessage());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        HeaderValue value;
        if (header == null) {
            BundleVersionParser.$$$reportNull$$$0(2);
        }
        if ((value = header.getHeaderValue()) instanceof HeaderValuePart) {
            try {
                return new Version(value.getUnwrappedText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/osmorc/manifest/lang/header/BundleVersionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConvertedValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

