/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.util.OsgiPsiUtil;

public class PackageAccessibilityInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean checkTests = false;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(OsmorcBundle.message("PackageAccessibilityInspection.ui.check.tests", new Object[0]), (InspectionProfileEntry)this, "checkTests");
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            PackageAccessibilityInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PackageAccessibilityInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PsiClassOwner) || !this.checkTests && ProjectRootsUtil.isInTestSource((PsiFile)file)) {
            return null;
        }
        final OsmorcFacet facet = OsmorcFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        final List problems = ContainerUtil.newSmartList();
        DependenciesBuilder.analyzeFileDependencies((PsiFile)file, (DependenciesBuilder.DependencyProcessor)new DependenciesBuilder.DependencyProcessor(){

            public void process(PsiElement place, PsiElement dependency) {
                Problem problem;
                if (dependency instanceof PsiClass && (problem = PackageAccessibilityInspection.checkAccessibility((PsiClass)dependency, facet)) != null) {
                    problems.add(manager.createProblemDescriptor(place, problem.message, isOnTheFly, problem.fixes, problem.type));
                }
            }
        }, (DependencyVisitorFactory.VisitorOptions)DependencyVisitorFactory.VisitorOptions.SKIP_IMPORTS);
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static Problem checkAccessibility(PsiClass targetClass, OsmorcFacet facet) {
        RetentionPolicy retention;
        if (targetClass.isAnnotationType() && ((retention = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)targetClass)) == RetentionPolicy.SOURCE || retention == RetentionPolicy.CLASS)) {
            return null;
        }
        PsiFile targetFile = targetClass.getContainingFile();
        if (!(targetFile instanceof PsiClassOwner)) {
            return null;
        }
        String packageName = ((PsiClassOwner)targetFile).getPackageName();
        if (packageName.isEmpty() || packageName.startsWith("java.")) {
            return null;
        }
        Module requestorModule = facet.getModule();
        Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetClass);
        if (targetModule == requestorModule) {
            return null;
        }
        BundleManifest importer = BundleManifestCache.getInstance(targetClass.getProject()).getManifest(requestorModule);
        if (importer != null && (importer.isPrivatePackage(packageName) || importer.getExportedPackage(packageName) != null)) {
            return null;
        }
        BundleManifest exporter = BundleManifestCache.getInstance(targetClass.getProject()).getManifest(targetClass);
        if (exporter == null || exporter.getBundleSymbolicName() == null) {
            return Problem.weak(OsmorcBundle.message("PackageAccessibilityInspection.non.osgi", packageName), new LocalQuickFix[0]);
        }
        String exportedPackage = exporter.getExportedPackage(packageName);
        if (exportedPackage == null) {
            return Problem.error(OsmorcBundle.message("PackageAccessibilityInspection.not.exported", packageName), new LocalQuickFix[0]);
        }
        if (!((OsmorcFacetConfiguration)facet.getConfiguration()).isManifestManuallyEdited()) {
            return null;
        }
        if (importer != null) {
            if (importer.isPackageImported(packageName)) {
                return null;
            }
            if (importer.isBundleRequired(exporter.getBundleSymbolicName())) {
                return null;
            }
        }
        return Problem.error(OsmorcBundle.message("PackageAccessibilityInspection.not.imported", packageName), new ImportPackageFix(exportedPackage));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/osmorc/inspection/PackageAccessibilityInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ImportPackageFix
    extends AbstractOsgiQuickFix {
        private final String myPackageToImport;

        ImportPackageFix(String packageToImport) {
            this.myPackageToImport = packageToImport;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("PackageAccessibilityInspection.fix", new Object[0]);
            if (string == null) {
                ImportPackageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ManifestFile manifestFile;
            if (project == null) {
                ImportPackageFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ImportPackageFix.$$$reportNull$$$0(2);
            }
            if ((manifestFile = this.getVerifiedManifestFile(descriptor.getPsiElement())) != null) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{manifestFile}).run(() -> OsgiPsiUtil.appendToHeader(manifestFile, "Import-Package", this.myPackageToImport));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/osmorc/inspection/PackageAccessibilityInspection$ImportPackageFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/osmorc/inspection/PackageAccessibilityInspection$ImportPackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Problem {
        public final ProblemHighlightType type;
        public final String message;
        public final LocalQuickFix[] fixes;

        private Problem(ProblemHighlightType type, String message, LocalQuickFix ... fixes) {
            this.type = type;
            this.message = message;
            this.fixes = fixes.length > 0 ? fixes : null;
        }

        public static Problem weak(String message, LocalQuickFix ... fixes) {
            return new Problem(ProblemHighlightType.WEAK_WARNING, message, fixes);
        }

        public static Problem error(String message, LocalQuickFix ... fixes) {
            return new Problem(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, message, fixes);
        }
    }
}

