/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.impl.ui.FacetEditorsFactoryImpl;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import icons.OsmorcIdeaIcons;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.jar.Manifest;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Version;

public class OsgiCoreLibraryType
extends DownloadableLibraryType {
    private static final String ID = "org.osgi.core";
    private static final String DETECTOR_CLASS = "org.osgi.framework.Constants";

    public OsgiCoreLibraryType() {
        super("OSGi Core API", ID, ID, new URL[]{OsgiCoreLibraryType.class.getResource("osgi.core.xml")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            OsgiCoreLibraryType.$$$reportNull$$$0(0);
        }
        if (!LibraryUtil.isClassAvailableInLibrary(roots, (String)DETECTOR_CLASS)) {
            return null;
        }
        VirtualFile jar = LibrariesHelper.getInstance().findRootByClass(roots, DETECTOR_CLASS);
        if (jar == null) return new LibraryVersionProperties(null);
        if (!(jar.getFileSystem() instanceof JarFileSystem)) return new LibraryVersionProperties(null);
        VirtualFile manifestFile = jar.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) return new LibraryVersionProperties(null);
        try (InputStream input = manifestFile.getInputStream();){
            String version = new Manifest(input).getMainAttributes().getValue("Bundle-Version");
            if (version == null) return new LibraryVersionProperties(null);
            try {
                Version v = new Version(version);
                LibraryVersionProperties libraryVersionProperties = new LibraryVersionProperties(v.getMajor() + "." + v.getMinor() + "." + v.getMicro());
                return libraryVersionProperties;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new LibraryVersionProperties(null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new LibraryVersionProperties(null);
    }

    @NotNull
    public Icon getLibraryTypeIcon() {
        Icon icon = OsmorcIdeaIcons.Osgi;
        if (icon == null) {
            OsgiCoreLibraryType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    protected String[] getDetectionClassNames() {
        Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)((Object)new AssertionError((Object)"shouldn't be called")));
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public static boolean isOsgiCoreLibrary(@NotNull Library library) {
        if (library == null) {
            OsgiCoreLibraryType.$$$reportNull$$$0(2);
        }
        VirtualFile[] roots = library.getFiles(OrderRootType.CLASSES);
        return LibraryUtil.isClassAvailableInLibrary((VirtualFile[])roots, (String)DETECTOR_CLASS);
    }

    public static FrameworkLibraryValidator getValidator(FacetEditorContext context, FacetValidatorsManager manager) {
        CustomLibraryDescription description = DownloadableLibraryService.getInstance().createDescriptionForType(OsgiCoreLibraryType.class);
        return FacetEditorsFactoryImpl.getInstanceImpl().createLibraryValidator(description, context, manager, ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/facet/OsgiCoreLibraryType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/facet/OsgiCoreLibraryType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOsgiCoreLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

