/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.project;

import aQute.bnd.header.Parameters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleManifest {
    private final Map<String, String> myMap;
    private final PsiFile mySource;

    public BundleManifest(@NotNull Map<String, String> map) {
        if (map == null) {
            BundleManifest.$$$reportNull$$$0(0);
        }
        this(map, null);
    }

    public BundleManifest(@NotNull Map<String, String> map, @Nullable PsiFile source) {
        if (map == null) {
            BundleManifest.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        this.myMap = ContainerUtil.newHashMap(map);
    }

    @Nullable
    public PsiFile getSource() {
        return this.mySource;
    }

    @Nullable
    public String get(@NotNull String attr) {
        if (attr == null) {
            BundleManifest.$$$reportNull$$$0(2);
        }
        return this.myMap.get(attr);
    }

    @Nullable
    public String getBundleSymbolicName() {
        return this.get("Bundle-SymbolicName");
    }

    @Nullable
    public String getBundleActivator() {
        return this.get("Bundle-Activator");
    }

    @Nullable
    public String getExportedPackage(@NotNull String packageName) {
        if (packageName == null) {
            BundleManifest.$$$reportNull$$$0(3);
        }
        for (String exported : this.getValues("Export-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)(exported = StringUtil.trimEnd((String)exported, (String)".*")))) continue;
            return exported;
        }
        return null;
    }

    public boolean isPackageImported(@NotNull String packageName) {
        if (packageName == null) {
            BundleManifest.$$$reportNull$$$0(4);
        }
        for (String imported : this.getValues("Import-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)imported)) continue;
            return true;
        }
        return false;
    }

    public boolean isBundleRequired(@NotNull String bsn) {
        if (bsn == null) {
            BundleManifest.$$$reportNull$$$0(5);
        }
        for (String bundleName : this.getValues("Require-Bundle")) {
            if (!bsn.equals(bundleName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrivatePackage(@NotNull String packageName) {
        if (packageName == null) {
            BundleManifest.$$$reportNull$$$0(6);
        }
        for (String privatePkg : this.getValues("Private-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)privatePkg)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getValues(String header) {
        String value = this.get(header);
        return StringUtil.isEmptyOrSpaces((String)value) ? Collections.emptySet() : new Parameters(value).keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bsn";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/osgi/project/BundleManifest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExportedPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPackageImported";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isBundleRequired";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrivatePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

