/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class SpringBeanPointerDependenciesListener
implements Disposable {
    private final MergingUpdateQueue myModelFilesQueue;
    private final ParameterizedCachedValue<Object, PsiFile> myJavaStructureCachedValueTrigger;

    SpringBeanPointerDependenciesListener(final SpringBeanPointerFinderRecursivePanel panel) {
        this.myModelFilesQueue = new MergingUpdateQueue("Model Files", 1000, true, (JComponent)((Object)panel), (Disposable)this);
        Project project = panel.getProject();
        this.myJavaStructureCachedValueTrigger = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Object, PsiFile>(){

            public CachedValueProvider.Result<Object> compute(PsiFile psiFile) {
                SpringBeanPointerDependenciesListener.this.scheduleModelFilesRecalculation(panel, psiFile);
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                PsiFile file;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (panel.knowsAboutConfigurationFile(file = event.getFile())) {
                    panel.updatePanel();
                    return;
                }
                if (file instanceof PsiClassOwner) {
                    SpringBeanPointerDependenciesListener.this.myJavaStructureCachedValueTrigger.getValue((Object)file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/toolWindow/panels/SpringBeanPointerDependenciesListener$2", "childrenChanged"));
            }
        }, (Disposable)this);
        Disposer.register((Disposable)panel, (Disposable)this);
    }

    private void scheduleModelFilesRecalculation(final SpringBeanPointerFinderRecursivePanel panel, final PsiFile psiFile) {
        this.myModelFilesQueue.queue(new Update("Recalculate model files"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)psiFile.getProject()).runReadActionInSmartMode(() -> {
                    panel.getListItems();
                    if (panel.knowsAboutConfigurationFile(psiFile)) {
                        panel.updatePanel();
                    }
                }));
            }
        });
    }

    public void dispose() {
        this.myModelFilesQueue.cancelAllUpdates();
    }
}

