/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.ui.FinderRecursivePanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanPointerPanelBase
extends FinderRecursivePanel<SpringBeanPointer> {
    protected SpringBeanPointerPanelBase(@NotNull FinderRecursivePanel parent) {
        if (parent == null) {
            SpringBeanPointerPanelBase.$$$reportNull$$$0(0);
        }
        super(parent);
    }

    protected SpringBeanPointerPanelBase(@NotNull Project project, @Nullable String groupId) {
        if (project == null) {
            SpringBeanPointerPanelBase.$$$reportNull$$$0(1);
        }
        super(project, groupId);
    }

    protected SpringBeanPointerPanelBase(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId) {
        if (project == null) {
            SpringBeanPointerPanelBase.$$$reportNull$$$0(2);
        }
        super(project, parent, groupId);
    }

    @NotNull
    protected String getItemText(SpringBeanPointer pointer) {
        String string = this.isNotDumb() && pointer.isValid() ? SpringPresentationProvider.getSpringBeanName(pointer) : "<invalid>";
        if (string == null) {
            SpringBeanPointerPanelBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringBeanPointer pointer) {
        return this.isNotDumb() && pointer.isValid() ? SpringPresentationProvider.getSpringIcon(pointer) : null;
    }

    @Nullable
    protected VirtualFile getContainingFile(SpringBeanPointer pointer) {
        return pointer.isValid() ? pointer.getContainingFile().getVirtualFile() : null;
    }

    @Nullable
    protected String getItemTooltipText(SpringBeanPointer pointer) {
        PsiType beanType;
        CommonSpringBean bean;
        if (!this.isNotDumb()) {
            return null;
        }
        CommonSpringBean commonSpringBean = bean = pointer.isValid() ? (CommonSpringBean)pointer.getSpringBean() : null;
        if (bean != null && (beanType = bean.getBeanType(true)) != null) {
            return beanType.getCanonicalText();
        }
        return null;
    }

    protected boolean performEditAction() {
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)this.getSelectedValue();
        if (springBeanPointer == null) {
            return true;
        }
        PsiElement navigationElement = springBeanPointer.getPsiElement();
        if (navigationElement != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)navigationElement);
        }
        return true;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        SpringBeanPointer selectedValue;
        if (dataId == null) {
            SpringBeanPointerPanelBase.$$$reportNull$$$0(4);
        }
        if ((selectedValue = (SpringBeanPointer)this.getSelectedValue()) != null && selectedValue.isValid()) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return selectedValue.getSpringBean().getIdentifyingPsiElement();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return selectedValue.getContainingFile();
            }
        }
        return super.getData(dataId);
    }

    protected boolean isNotDumb() {
        return !this.getProject().isDisposed() && !DumbService.isDumb((Project)this.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/SpringBeanPointerPanelBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeanPointerPanelBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

